#include "cbn1768.h"
#include "lcd.h"

/*----------------------------------------------------------*\
 | Exported                                                 |
\*----------------------------------------------------------*/
volatile unsigned char Font=0;

#define LCD_RESET_PIN   (1<<10)
#define LCD_CS_PIN      (1<<6)
/* SSPSR - bit definitions. */
#define TFE     0x01
#define TNF     0x02
#define RNE     0x04
#define RFF     0x08
#define BSY     0x10

/*----------------------------------------------------------*\
 | Delay                                                    |
\*----------------------------------------------------------*/
void  Delay(unsigned int  dly) {
    unsigned int  i;

    for (; dly>0; dly--)
        for (i=0; i<5000; i++);
}
/*----------------------------------------------------------*\
 | ILI9325 SSP Initialize                                       |
\*----------------------------------------------------------*/
void  SSP_Init(void) {


    PCONP |= 1<<10;

    // PINSEL0 |= (1<<13); //ssel1-p0.6
    PINSEL0 |= (1<<15); //sck1-p0.7
    PINSEL0 |= (1<<17); //mosi1-p0.8
    PINSEL0 |= (1<<19); //sck1-p0.9




    SSP1CR0 = (0x01 << 8) |              // SCR  &#65533;&#65533;&#65533;&#65533;SPI&#689;&#65533;&#1271;&#65533;&#437;
              (0x01 << 7) |              // CPHA &#689;&#65533;&#65533;&#65533;&#65533;&#65533;&#65533;&#65533;&#955;,&#65533;&#65533;SPI&#291;&#701;&#65533;&#65533;&#1063;
              (0x01 << 6) |              // CPOL &#689;&#65533;&#65533;&#65533;&#65533;&#65533;&#65533;&#65533;,&#65533;&#65533;SPI&#291;&#701;&#65533;&#65533;&#1063;
              (0x00 << 4) |              // FRF  &#1441;&#65533;&#65533;&#701; 00=SPI,01=SSI,10=Microwire,11=&#65533;&#65533;&#65533;&#65533;
              (0x07 << 0);               // DSS  &#65533;&#65533;&#1907;&#65533;&#65533;&#65533;,0000-0010=&#65533;&#65533;&#65533;&#65533;,0011=4&#955;,0111=8&#955;,1111=16&#955;

    SSP1CR1 = (0x00 << 3) |              // SOD  &#65533;&#1275;&#65533;&#65533;&#65533;&#65533;&#65533;&#65533;&#65533;,1=&#65533;&#65533;&#1465;,0=&#65533;&#65533;&#65533;&#65533;
              (0x00 << 2) |              // MS   &#65533;&#65533;&#65533;&#1121;&#65533;&#65533;,0=&#65533;&#65533;&#65533;,1=&#65533;&#1275;&#65533;
              (0x01 << 1) |              // SSE  SSP&#697;&#65533;&#65533;,1=&#65533;&#65533;&#65533;&#65533;SSP&#65533;&#65533;&#65533;&#65533;&#65533;&#65533;&#65533;&#35960;&#872;&#65533;&#65533;
              (0x00 << 0);               // LBM  &#65533;&#65533;&#1076;&#291;&#701;

    //SSPCPSR = 0x02;                     // PCLK&#65533;&#65533;&#437;&#1461;
    SSP1CPSR = 0x04;                     // PCLK&#65533;&#65533;&#437;&#1461;
    SSP1IMSC = 0x07;                     // &#65533;&#1078;&#65533;&#65533;&#65533;&#956;&#308;&#65533;&#65533;&#65533;
    SSP1ICR  = 0x03;                     // &#65533;&#1078;&#65533;&#65533;&#65533;&#65533;&#308;&#65533;&#65533;&#65533;
}
/*----------------------------------------------------------*\
 | ILI9325 Write Byte                                       |
\*----------------------------------------------------------*/
unsigned char  LCD_Access(unsigned char byte) {
    // &#65533;&#564;&#65533;SPIF&#65533;&#65533;&#955;&#65533;&#65533;&#65533;&#65533;&#65533;&#564;&#65533;&#65533;&#65533;&#1911;&#65533;&#65533;&#65533;&#65533;&#65533;&#65533;
    /* Wait if TNF cleared, Tx FIFO is full. */
    while ((SSP1SR & TNF) == 0);
    SSP1DR = byte;
    /* Wait if RNE cleared, Rx FIFO is empty. */
    while ((SSP1SR & RNE) == 0);
    return SSP1DR;
}

/*-----------------------------------------------------------------------------*\
 | LCD_WriteReg   : Writes to the selected LCD register.                       |
 | Input          : - LCD_Reg: address of the selected register.               |
 |                  - LCD_RegValue: value to write to the selected register.   |
 | Output         : None                                                       |
 | Return         : None                                                       |
\*-----------------------------------------------------------------------------*/
void LCD_WriteReg(unsigned short LCD_Reg, unsigned short LCD_RegValue) {
    FIO0CLR = LCD_CS_PIN;
    // write register index
    LCD_Access( 0x70 ); // RS=0:register; RW=0:write. -- write Index
    LCD_Access( 0x00 );
    LCD_Access( LCD_Reg & 0xFF );
    FIO0SET = LCD_CS_PIN;
    // write register data
    //Delay(1);
    FIO0CLR = LCD_CS_PIN;
    LCD_Access( 0x72 ); // RS=1:data; RW=0:write. -- write Index
    LCD_Access( LCD_RegValue>>8 );
    LCD_Access( LCD_RegValue & 0xFF );
    FIO0SET = LCD_CS_PIN;
}
void LCD_Reg(unsigned short LCD_Reg) {
    FIO0CLR = LCD_CS_PIN;
    // write register index
    LCD_Access( 0x70 ); // RS=0:register; RW=0:write. -- write Index
    LCD_Access( 0x00 );
    LCD_Access( LCD_Reg & 0xFF );
    FIO0SET = LCD_CS_PIN;
}
/*-----------------------------------------------------------------------------*\
 | LCD_ReadReg    : Reads the selected LCD Register.                           |
 | Input          : None                                                       |
 | Output         : None                                                       |
 | Return         : LCD Register Value.                                        |
\*-----------------------------------------------------------------------------*/
unsigned short LCD_ReadReg(unsigned char LCD_Reg) {
    unsigned short Val;

    FIO0CLR = LCD_CS_PIN;
    // write register index
    LCD_Access( 0x70 ); // RS=0:register; RW=0:write. -- write Index
    LCD_Access( 0x00 );
    LCD_Access( LCD_Reg & 0xFF );
    FIO0SET = LCD_CS_PIN;
    // read register data
    //Delay(1);
    FIO0CLR = LCD_CS_PIN;
    LCD_Access( 0x73 ); // RS=1:data; RW=1:read. -- read Index
    LCD_Access( 0x00 ); // dummy read one byte
    Val = LCD_Access( 0 ) << 8;
    Val |= LCD_Access( 0 );
    FIO0SET = LCD_CS_PIN;

    return Val;
}
/*-----------------------------------------------------------------------------*\
 | LCD_WriteRAM   : Writes to the LCD RAM.                                     |
 | Input          : - RGB_Code: the pixel color in RGB mode (5-6-5).           |
 | Output         : None                                                       |
 | Return         : None                                                       |
\*-----------------------------------------------------------------------------*/
void LCD_WriteRAM(unsigned short RGB_Code) {
    FIO0CLR = LCD_CS_PIN;
    LCD_Access( 0x72 ); // RS=1:data; RW=0:write. -- write data
    LCD_Access( RGB_Code>>8 );
    LCD_Access( RGB_Code & 0xFF );
    FIO0SET = LCD_CS_PIN;
}
/*----------------------------------------------------------*\
 | ILI9325 Initialize                                       |
\*----------------------------------------------------------*/
void  LCD_Init(void) {
    unsigned short ID;

    PINSEL1 &= ~0x000000FC;    // &#65533;&#65533;&#65533;&#65533;SPI&#65533;&#1853;&#65533;&#65533;&#65533;&#65533;
    PINSEL1 |=  0x000000A8;    // &#65533;&#65533;&#65533;&#65533;SPI&#65533;&#1853;&#65533;&#65533;&#65533;&#65533;

    FIO0DIR |= LCD_CS_PIN | LCD_RESET_PIN;    // CS/DC/RST
    FIO0CLR = (1<<18);

    FIO0SET = LCD_CS_PIN;
    FIO0CLR = LCD_RESET_PIN;

    SSP_Init();

    Delay(50); /* delay 50 ms */
    FIO0SET=LCD_RESET_PIN;

    Delay(50); /* delay 50 ms */
    ID = LCD_ReadReg( 0x0000 );   // Read driver IC ID
    if ( (ID != 0x9325) && (ID != 0x9328) ) return;   // the ID must be 0x9325 or 0x9328
    Delay(50); /* delay 50 ms */
    //************* Start Initial Sequence **********//
    LCD_WriteReg(0x00E7, 0x0010); // Set internal timing
    LCD_WriteReg(0x0000, 0x0001); // Start Oscillation
    //LCD_WriteReg(0x0001, 0x0100); // set SS and SM bit
    LCD_WriteReg(0x0001, 0x0000); // set SS and SM bit
    LCD_WriteReg(0x0002, 0x0700); // set 1 line inversion
    LCD_WriteReg(0x0003, (1<<12)|(1<<5)|(1<<4)|(1<<3) ); // 65K
    LCD_WriteReg(0x0004, 0x0000); // Resize register
    LCD_WriteReg(0x0008, 0x0207); // set the back porch and front porch
    LCD_WriteReg(0x0009, 0x0000); // set non-display area refresh cycle ISC[3:0]
    LCD_WriteReg(0x000A, 0x0000); // FMARK function
    LCD_WriteReg(0x000C, 0x0001); // RGB interface setting: 16 bit
    LCD_WriteReg(0x000D, 0x0000); // Frame marker Position
    LCD_WriteReg(0x000F, 0x0000); // RGB interface polarity
    //*************Power On sequence ****************//
    LCD_WriteReg(0x0010, 0x0000); // SAP, BT[3:0], AP, DSTB, SLP, STB
    LCD_WriteReg(0x0011, 0x0007); // DC1[2:0], DC0[2:0], VC[2:0]
    LCD_WriteReg(0x0012, 0x0000); // VREG1OUT voltage
    Delay(50);                         // Delay 50ms
    LCD_WriteReg(0x0013, 0x0000); // VDV[4:0] for VCOM amplitude
    Delay(200);                         // Delay 50ms
    LCD_WriteReg(0x0010, 0x1590); // SAP, BT[3:0], AP, DSTB, SLP, STB
    LCD_WriteReg(0x0011, 0x0227); // R11h=0x0221 at VCI=3.3V, DC1[2:0], DC0[2:0], VC[2:0]
    Delay(50);                         // Delay 50ms
    LCD_WriteReg(0x0012, 0x009C); // External reference voltage= Vci;
    Delay(50);                         // Delay 50ms
    LCD_WriteReg(0x0013, 0x1900); // VDV[4:0] for VCOM amplitude
    LCD_WriteReg(0x0029, 0x0023); // VCM[5:0] for VCOMH
    LCD_WriteReg(0x002B, 0x000E); // Frame Rate = 40Hz
    Delay(50);                         // Delay 50ms
    LCD_WriteReg(0x0020, 0x0000); // GRAM horizontal Address
    LCD_WriteReg(0x0021, 0x0000); // GRAM Vertical Address
    Delay(50);                         // Delay 50ms
    // ----------- Adjust the Gamma Curve ----------//
    LCD_WriteReg(0x0030, 0x0007);
    LCD_WriteReg(0x0031, 0x0707);
    LCD_WriteReg(0x0032, 0x0006);
    LCD_WriteReg(0x0035, 0x0704);
    LCD_WriteReg(0x0036, 0x1F04);
    LCD_WriteReg(0x0037, 0x0004);
    LCD_WriteReg(0x0038, 0x0000);
    LCD_WriteReg(0x0039, 0x0706);
    LCD_WriteReg(0x003C, 0x0701);
    LCD_WriteReg(0x003D, 0x000F);
    Delay(50);                         // Delay 50ms
    //------------------ Set GRAM area ---------------//
    LCD_WriteReg(0x0050, 0x0000); // Horizontal GRAM Start Address
    LCD_WriteReg(0x0051, 0x00EF); // Horizontal GRAM End Address
    LCD_WriteReg(0x0052, 0x0000); // Vertical GRAM Start Address
    LCD_WriteReg(0x0053, 0x013F); // Vertical GRAM Start Address
    LCD_WriteReg(0x0060, 0xA700); // Gate Scan Line
    //LCD_WriteReg(0x0060, 0x2700); // Gate Scan Line
    LCD_WriteReg(0x0061, 0x0001); // NDL,VLE, REV
    LCD_WriteReg(0x006A, 0x0000); // set scrolling line
    //-------------- Partial Display Control ---------//
    LCD_WriteReg(0x0080, 0x0000);
    LCD_WriteReg(0x0081, 0x0000);
    LCD_WriteReg(0x0082, 0x0000);
    LCD_WriteReg(0x0083, 0x0000);
    LCD_WriteReg(0x0084, 0x0000);
    LCD_WriteReg(0x0085, 0x0000);
    //-------------- Panel Control -------------------//
    LCD_WriteReg(0x0090, 0x0010);
    LCD_WriteReg(0x0092, 0x0000);
    LCD_WriteReg(0x0093, 0x0003);
    LCD_WriteReg(0x0095, 0x0110);
    LCD_WriteReg(0x0097, 0x0000);
    LCD_WriteReg(0x0098, 0x0000);
    //----------------- display ON -------------------//
    LCD_WriteReg(0x0007, 0x0133); // 262K color and display ON
    LCD_WriteReg(0x0020, 0x0000);
    LCD_WriteReg(0x0021, 0x0000);
}
/*-----------------------------------------------------------------------------*\
 | LCD_SetCursor  : Sets the cursor position.                                  |
 | Input          : - Xpos: specifies the X position.                          |
 |                  - Ypos: specifies the Y position.                          |
\*-----------------------------------------------------------------------------*/
void LCD_SetCursor(unsigned short Xpos, unsigned short Ypos) {
    LCD_WriteReg(R33, Xpos);
    LCD_WriteReg(R32, Ypos);
}
/*-----------------------------------------------------------------------------*\
 | LCD_SetArea  : Sets a display window                                        |
\*-----------------------------------------------------------------------------*/
void LCD_SetArea( unsigned short x0, unsigned short y0, unsigned short x1, unsigned short y1 ) {
    LCD_SetCursor(x0, y0);
    /* Horizontal GRAM Start Address */
    LCD_WriteReg(R80, y0);
    /* Horizontal GRAM End Address */
    LCD_WriteReg(R81, y1);
    /* Vertical GRAM Start Address */
    LCD_WriteReg(R82, x0);
    /* Vertical GRAM End Address */
    LCD_WriteReg(R83, x1);
}
/*-----------------------------------------------------------------------------*\
 | LCD_RectangleFill  : Displays a rectangle filled                            |
\*-----------------------------------------------------------------------------*/
void LCD_Rectangle( unsigned short x0, unsigned short y0, unsigned short x1, unsigned short y1, unsigned short Color ) {
    int x,y;

    LCD_SetArea(x0,y0,x1,y1);

    LCD_Reg( R34 ); /* Prepare to write GRAM */
    for (x=0;x<=x1-x0;x++)
        for (y=0;y<=y1-y0;y++)
            LCD_WriteRAM( Color );
}
/*-----------------------------------------------------------------------------*\
 | LCD_Clear    : Clears the hole LCD.                                         |
\*-----------------------------------------------------------------------------*/
void LCD_Clear_Screen( unsigned short Color ) {
    LCD_Rectangle( 0,0, 319,239, Color );
}
/*-----------------------------------------------------------------------------*\
 | LCD_SetPixel  : Displays a pixel.                                           |
\*-----------------------------------------------------------------------------*/
void LCD_SetPixel( unsigned short x, unsigned short y, unsigned short Color ) {
    LCD_SetArea(x,y,x,y);
    LCD_Reg( R34 ); /* Prepare to write GRAM */
    LCD_WriteRAM( Color );
}
/*-----------------------------------------------------------------------------*\
 | LCD_PutChar8x16  : Displays a 8x16 pixel charactor                          |
\*-----------------------------------------------------------------------------*/
#include "8x16.h"
void LCD_PutChar8x16(unsigned short x, unsigned short y, char c, unsigned int f, unsigned int b) {
    register unsigned int i,j;

    LCD_SetArea(x,y,x+8-1,y+16-1);
    LCD_Reg( R34 ); /* Prepare to write GRAM */

    for (i=0; i<16;i++) {
        unsigned char m=Font8x16[c*16+i];
        for (j=0;j<8;j++) {
            if ((m&0x80))
                LCD_WriteRAM( f );
            else
                LCD_WriteRAM( b );
            m<<=1;
        }
    }
}
/*-----------------------------------------------------------------------------*\
 | LCD_PutChar8x8  : Displays a 8x8 pixel charactor                            |
\*-----------------------------------------------------------------------------*/
#include "8x8h.h"
void LCD_PutChar8x8(unsigned short x, unsigned short y, char c, unsigned int f, unsigned int b) {
    register unsigned int i,j;

    LCD_SetArea(x,y,x+8-1,y+8-1);
    LCD_Reg( R34 ); /* Prepare to write GRAM */

    for (i=0; i<8;i++) {
        unsigned char m=Font8x8[c][i];
        for (j=0;j<8;j++) {
            if ((m&0x80))
                LCD_WriteRAM( f );
            else
                LCD_WriteRAM( b );
            m<<=1;
        }
    }
}
/*-----------------------------------------------------------------------------*\
 | LCD_PutGB1616  : Displays a Chinese charactor use small libary              |
\*-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*\
 | LCD_PutChar  : Displays a charactor on Font                                 |
\*-----------------------------------------------------------------------------*/
void LCD_PutChar(unsigned short x, unsigned short y, char c, unsigned int f, unsigned int b) {
    if ( Font )
        LCD_PutChar8x8( x, y, c, f, b );
    else
        LCD_PutChar8x16( x, y, c, f, b );
}
/*-----------------------------------------------------------------------------*\
 | LCD_PutString  : Displays a string                                          |
\*-----------------------------------------------------------------------------*/
void LCD_PutString(unsigned short x, unsigned short y, char *s, unsigned int f, unsigned int b) {
    register unsigned char l=0;
    while (*s) {
        if ( *s < 0x80 ) {
            LCD_PutChar(x+l*8,y,*s,f,b);
            s++;
            l++;
        } else {
          //  LCD_PutGB1616(x+l*8,y,(unsigned char *)s,f,b);
            s+=2;
            l+=2;
        }
    }
}


void LCD_RESIM_YATAY(int x0,int y0,int g,int y,int rg,int ry, const unsigned char bmp[]) {

    int i,j;
    int p=0;
    int c;

    LCD_SetArea(x0,y0,x0+g-1,y0+y-1);
    LCD_Reg( R34 ); /* Prepare to write GRAM */

    for (j= 0;j<y;j++) {
        p=0;
        for ( i = x0; i<x0+g; i++ ) {
            c = bmp[p+1+j*rg*2] | (bmp[p +j*rg*2]<<8) ;
            LCD_WriteRAM(c);
            p = p + 2;

        }

    }


}


/*----------------------------------------------------------*\
 | END OF FILE                                              |
\*----------------------------------------------------------*/