

/* System Control Miscellaneous */
#define SCS             (*((volatile unsigned long *) 0x400FC1A0))

/* Pin Connect Block */
#define PINSEL0         (*((volatile unsigned long *) 0x4002C000))
#define PINSEL1         (*((volatile unsigned long *) 0x4002C004))
#define PINSEL2         (*((volatile unsigned long *) 0x4002C008))
#define PINSEL3         (*((volatile unsigned long *) 0x4002C00C))
#define PINSEL4         (*((volatile unsigned long *) 0x4002C010))
#define PINSEL7         (*((volatile unsigned long *) 0x4002C01C))
#define PINSEL8         (*((volatile unsigned long *) 0x4002C020))
#define PINSEL9         (*((volatile unsigned long *) 0x4002C024))
#define PINSEL10         (*((volatile unsigned long *) 0x4002C028))


/* General Purpose Input/Output (GPIO) */
#define FIO0DIR        (*((volatile unsigned long *) 0x2009C000))
#define FIO1DIR        (*((volatile unsigned long *) 0x2009C020))
#define FIO2DIR        (*((volatile unsigned long *) 0x2009C040))
#define FIO3DIR        (*((volatile unsigned long *) 0x2009C060))
#define FIO4DIR        (*((volatile unsigned long *) 0x2009C080))

#define FIO0MASK        (*((volatile unsigned long *) 0x2009C010))
#define FIO1MASK        (*((volatile unsigned long *) 0x2009C030))
#define FIO2MASK        (*((volatile unsigned long *) 0x2009C050))
#define FIO3MASK        (*((volatile unsigned long *) 0x2009C070))
#define FIO4MASK        (*((volatile unsigned long *) 0x2009C090))

#define FIO0PIN        (*((volatile unsigned long *) 0x2009C014))
#define FIO1PIN        (*((volatile unsigned long *) 0x2009C034))
#define FIO2PIN        (*((volatile unsigned long *) 0x2009C054))
#define FIO3PIN        (*((volatile unsigned long *) 0x2009C074))
#define FIO4PIN        (*((volatile unsigned long *) 0x2009C094))


#define FIO0SET        (*((volatile unsigned long *) 0x2009C018))
#define FIO1SET        (*((volatile unsigned long *) 0x2009C038))
#define FIO2SET        (*((volatile unsigned long *) 0x2009C058))
#define FIO3SET        (*((volatile unsigned long *) 0x2009C078))
#define FIO4SET        (*((volatile unsigned long *) 0x2009C098))


#define FIO0CLR        (*((volatile unsigned long *) 0x2009C01C))
#define FIO1CLR        (*((volatile unsigned long *) 0x2009C03C))
#define FIO2CLR        (*((volatile unsigned long *) 0x2009C05C))
#define FIO3CLR        (*((volatile unsigned long *) 0x2009C07C))
#define FIO4CLR        (*((volatile unsigned long *) 0x2009C09C))

/* Universal Asynchronous Receiver Transmitter 0(UART0) */
#define U0RBR           (*((volatile unsigned char *) 0x4000C000))
#define U0THR           (*((volatile unsigned char *) 0x4000C000))
#define U0IER           (*((volatile unsigned long *) 0x4000C004))
#define U0IIR           (*((volatile unsigned long *) 0x4000C008))
#define U0FCR           (*((volatile unsigned char *) 0x4000C008))
#define U0LCR           (*((volatile unsigned char *) 0x4000C00C))
#define U0MCR           (*((volatile unsigned char *) 0x4000C010))
#define U0LSR           (*((volatile unsigned char *) 0x4000C014))
#define U0MSR           (*((volatile unsigned char *) 0x4000C018))
#define U0SCR           (*((volatile unsigned char *) 0x4000C01C))
#define U0DLL           (*((volatile unsigned char *) 0x4000C000))
#define U0DLM           (*((volatile unsigned char *) 0x4000C004))
#define U0ACR           (*((volatile unsigned long *) 0x4000C020))
#define U0ICR           (*((volatile unsigned long *) 0x4000C024))
#define U0FDR           (*((volatile unsigned long *) 0x4000C028))
#define U0TER           (*((volatile unsigned char *) 0x4000C030))

/* Universal Asynchronous Receiver Transmitter 1(UART1) */
#define U1RBR           (*((volatile unsigned char *) 0x40010000))
#define U1THR           (*((volatile unsigned char *) 0x40010000))
#define U1IER           (*((volatile unsigned long *) 0x40010004))
#define U1IIR           (*((volatile unsigned long *) 0x40010008))
#define U1FCR           (*((volatile unsigned char *) 0x40010008))
#define U1LCR           (*((volatile unsigned char *) 0x4001000C))
#define U1MCR           (*((volatile unsigned char *) 0x40010010))
#define U1LSR           (*((volatile unsigned char *) 0x40010014))
#define U1MSR           (*((volatile unsigned char *) 0x40010018))
#define U1SCR           (*((volatile unsigned char *) 0x4001001C))
#define U1DLL           (*((volatile unsigned char *) 0x40010000))
#define U1DLM           (*((volatile unsigned char *) 0x40010004))
#define U1ACR           (*((volatile unsigned long *) 0x40010020))
#define U1ICR           (*((volatile unsigned long *) 0x40010024))
#define U1FDR           (*((volatile unsigned long *) 0x40010028))
#define U1TER           (*((volatile unsigned char *) 0x40010030))


/* Universal Asynchronous Receiver Transmitter 2(UART2) */
#define U2RBR           (*((volatile unsigned char *) 0x40098000))
#define U2THR           (*((volatile unsigned char *) 0x40098000))
#define U2IER           (*((volatile unsigned long *) 0x40098004))
#define U2IIR           (*((volatile unsigned long *) 0x40098008))
#define U2FCR           (*((volatile unsigned char *) 0x40098008))
#define U2LCR           (*((volatile unsigned char *) 0x4009800C))
#define U2MCR           (*((volatile unsigned char *) 0x40098010))
#define U2LSR           (*((volatile unsigned char *) 0x40098014))
#define U2MSR           (*((volatile unsigned char *) 0x40098018))
#define U2SCR           (*((volatile unsigned char *) 0x4009801C))
#define U2DLL           (*((volatile unsigned char *) 0x40098000))
#define U2DLM           (*((volatile unsigned char *) 0x40098004))
#define U2ACR           (*((volatile unsigned long *) 0x40098020))
#define U2ICR           (*((volatile unsigned long *) 0x40098024))
#define U2FDR           (*((volatile unsigned long *) 0x40098028))
#define U2TER           (*((volatile unsigned char *) 0x40098030))


#define PCLKSEL0          (*((volatile unsigned short*) 0x400FC1A8))
#define PCLKSEL1          (*((volatile unsigned short*) 0x400FC1AC))

/* SPI0 (Serial Peripheral Interface 0) */
#define S0SPCR          (*((volatile unsigned short*) 0x40020000))
#define S0SPSR          (*((volatile unsigned char *) 0x40020004))
#define S0SPDR          (*((volatile unsigned short*) 0x40020008))
#define S0SPCCR         (*((volatile unsigned char *) 0x4002000C))
#define S0SPINT         (*((volatile unsigned char *) 0x4002001C))


/* SSP Controller (SPI1) */
#define SSP0CR0          (*((volatile unsigned short*) 0x40088000))
#define SSP1CR0          (*((volatile unsigned short*) 0x40030000))
#define SSP0CR1          (*((volatile unsigned char *) 0x40088004))
#define SSP1CR1          (*((volatile unsigned char *) 0x40030004))
#define SSP0DR           (*((volatile unsigned short*) 0x40088008))
#define SSP1DR           (*((volatile unsigned short*) 0x40030008))
#define SSP0SR           (*((volatile unsigned char *) 0x4008800C))
#define SSP1SR           (*((volatile unsigned char *) 0x4003000C))
#define SSP0CPSR         (*((volatile unsigned char *) 0x40088010))
#define SSP1CPSR         (*((volatile unsigned char *) 0x40030010))
#define SSP0IMSC         (*((volatile unsigned char *) 0x40088014))
#define SSP1IMSC         (*((volatile unsigned char *) 0x40030014))
#define SSP0RIS          (*((volatile unsigned char *) 0x40088018))
#define SSP1RIS          (*((volatile unsigned char *) 0x40030018))
#define SSP0MIS          (*((volatile unsigned char *) 0x4008801C))
#define SSP1MIS          (*((volatile unsigned char *) 0x4003001C))
#define SSP0ICR          (*((volatile unsigned char *) 0x40088020))
#define SSP1ICR          (*((volatile unsigned char *) 0x40030020))
#define SSP0DMACR        (*((volatile unsigned char *) 0x40088024))
#define SSP1DMACR        (*((volatile unsigned char *) 0x40030024))



/* A/D Converter 0 (AD0) */
#define AD0CR           (*((volatile unsigned long *) 0x40034000))
#define AD0GDR          (*((volatile unsigned long *) 0x40034004))
#define AD0STAT         (*((volatile unsigned long *) 0x40034030))
#define AD0INTEN        (*((volatile unsigned long *) 0x4003400C))
#define AD0DR0          (*((volatile unsigned long *) 0x40034010))
#define AD0DR1          (*((volatile unsigned long *) 0x40034014))
#define AD0DR2          (*((volatile unsigned long *) 0x40034018))
#define AD0DR3          (*((volatile unsigned long *) 0x4003401C))
#define AD0DR4          (*((volatile unsigned long *) 0x40034020))
#define AD0DR5          (*((volatile unsigned long *) 0x40034024))
#define AD0DR6          (*((volatile unsigned long *) 0x40034028))
#define AD0DR7          (*((volatile unsigned long *) 0x4003402C))
#define AD0TRM          (*((volatile unsigned long *) 0x40034034))

/* D/A Converter */
#define DACR            (*((volatile unsigned long *) 0x4008C000))


/* Power Control */
#define PCON           (*((volatile unsigned char *) 0x400FC0C0))
#define PCONP          (*((volatile unsigned long *) 0x400FC0C4))


/* Pulse Width Modulator (PWM) */
#define PWM1IR           (*((volatile unsigned long *) 0x40018000))
#define PWM1TCR          (*((volatile unsigned long *) 0x40018004))
#define PWM1TC           (*((volatile unsigned long *) 0x40018008))
#define PWM1PR           (*((volatile unsigned long *) 0x4001800C))
#define PWM1PC           (*((volatile unsigned long *) 0x40018010))
#define PWM1MCR          (*((volatile unsigned long *) 0x40018014))
#define PWM1MR0          (*((volatile unsigned long *) 0x40018018))
#define PWM1MR1          (*((volatile unsigned long *) 0x4001801C))
#define PWM1MR2          (*((volatile unsigned long *) 0x40018020))
#define PWM1MR3          (*((volatile unsigned long *) 0x40018024))

#define PWM1CCR          (*((volatile unsigned long *) 0x40018028))
#define PWM1CR0          (*((volatile unsigned long *) 0x4001802C))
#define PWM1CR1          (*((volatile unsigned long *) 0x40018030))
#define PWM1CR2          (*((volatile unsigned long *) 0x40018034))
#define PWM1CR3          (*((volatile unsigned long *) 0x40018038))

#define PWM1MR4          (*((volatile unsigned long *) 0x40018040))
#define PWM1MR5          (*((volatile unsigned long *) 0x40018044))
#define PWM1MR6          (*((volatile unsigned long *) 0x40018048))
#define PWM1PCR          (*((volatile unsigned long *) 0x4001804C))
#define PWM1LER          (*((volatile unsigned long *) 0x40018050))

#define PWM1CTCR         (*((volatile unsigned long *) 0x40018070))