#include "mbed.h"
#include "SPI_TFT.h"
#include "Arial12x12.h"
#include "Arial28x28.h"
#include "touch_tft.h"


// the TFT is connected to SPI pin 5-7
// the touch is connected to 19,20,16,17

touch_tft tt(p19,p20,p16,p17,p11, p12, p13, p14, p15,"TFT"); // x+,x-,y+,y-,mosi, miso, sclk, cs, reset

int main() {

    unsigned short color = White;
    unsigned int brush = 2;
    point p;

    tt.claim(stdout);        // send stdout to the TFT display
    tt.background(Black);    // set background to black
    tt.foreground(White);    // set chars to white
    tt.cls();                // clear the screen
    tt.set_font((unsigned char*) Arial12x12);  // select the font
    tt.set_orientation(1);

    tt.calibrate();          // calibrate the touch
    tt.locate(0,0);
    printf(" x = ");
    tt.locate(0,12);
    printf(" y = ");
    tt.line(0,25,319,25,White);
    // the color chosing fields
    tt.fillrect(80,0,98,24,White);
    tt.fillrect(100,0,118,24,Green);
    tt.fillrect(120,0,138,24,Red);
    tt.fillrect(140,0,158,24,Blue);
    tt.line(179,0,179,24,White);
    // the brushes
    tt.fillcircle(190,12,2,White);
    tt.fillcircle(210,12,4,White);
    tt.fillcircle(230,12,6,White);
    tt.fillcircle(250,12,brush,color);
    while (1) {

        p = tt.get_touch();
        if (tt.is_touched(p)) {  // touch
        
            p = tt.to_pixel(p);          // convert to pixel pos
            if (p.y < 26) {        // a button field
                if (p.x > 80 && p.x < 100) {  // White
                    color = White;
                }
                if (p.x > 100 && p.x < 120) {  // Green
                    color = Green;
                }
                if (p.x > 120 && p.x < 140) {  // Red
                    color = Red;
                }
                if (p.x > 140 && p.x < 160) {  // Blue
                    color = Blue;
                }
                if (p.x > 160 && p.x < 180) {  // Black
                    color = Black;
                }
                if (p.x > 180 && p.x < 200) {  // brush 2
                    brush = 2;
                }
                if (p.x > 200 && p.x < 220) {  // brush 4
                    brush = 4;
                }
                if (p.x > 220 && p.x < 240) {  // brush 6
                    brush = 6;
                }
                if (color != Black) {
                    tt.fillrect(240,0,260,24,Black);
                } else {
                    tt.fillrect(240,0,260,24,White);
                }
                tt.fillcircle(250,12,brush,color);
                if (p.x > 300) {
                    tt.fillrect(0,26,319,239,Black);
                }
   
            } else {
                tt.fillcircle(p.x,p.y,brush,color);
                tt.locate(36,0);
                printf("%3d",p.x);
                tt.locate(36,12);
                printf("%3d",p.y);
            }
        }

    }

}




