#include "mbed.h"
#include "colors.h"

#define NUM_LED 8

//  hsv > rgb

void h2rgb(float H, float *R, float *G, float *B) {
    float S, V, C, H2, X;
    S = 1.0;
    V = 1.0;
    C = V * S;
    H = H - floor(H / 360.0) * 360.0;
    H2 = H / 60.0;
    X = C * (1.0 - fabs(fmodf(H2, 2.0) - 1.0));
    if (H2 < 1.0) { *R = C; *G = X; *B = 0; }
    else if (H2 < 2.0) { *R = X; *G = C; *B = 0; }
    else if (H2 < 3.0) { *R = 0; *G = C, *B = X; }
    else if (H2 < 4.0) { *R = 0; *G = X, *B = C; }
    else if (H2 < 5.0) { *R = X; *G = 0, *B = C; }
    else if (H2 < 6.0) { *R = C; *G = 0, *B = X; }
    *R += V - C;
    *G += V - C;
    *B += V - C;
}

//  main

Colors colorLEDs;

float hue = 0.0;
unsigned char colorData[NUM_LED][3];

int main() {
    //  setup
    colorLEDs.setup(NUM_LED);
    //  send
    while (1) {
        for (int i = 0; i < NUM_LED; i++) {
            float r, g, b;
            h2rgb(hue + i * 30.0, &r, &g, &b);
            colorData[i][0] = r * 255;
            colorData[i][1] = g * 255; 
            colorData[i][2] = b * 255;
            hue = hue + 0.05;
        }
        colorLEDs.send(colorData);
        //  
        hue += 0.05;
        wait_us(2000);
    }
}
