#include "mbed.h"
#include "colors.h"

BurstSPI Spi(p5, p6, p7);

void Colors::setup(int n) {
    num = n;
    Spi.frequency(2400000);
    Spi.format(12);
}

void Colors::sendOne(unsigned char r, unsigned char g, unsigned char b) {
    int data;
    //  W2812: g, r, b  (0:100, 1:110)
    //  g[7:4]  0000abcdxxxx
    //          1a01b01c01d0
    data = ((g & 0x80) << 3) | ((g & 0x40) << 1)
         | ((g & 0x20) >> 1) | ((g & 0x10) >> 3);
    Spi.fastWrite(data | 0x924);
    //  g[3:0]  0000xxxxabcd
    //          1a01b01c01d0
    data = ((g & 0x08) << 7) | ((g & 0x04) << 5)
         | ((g & 0x02) << 3) | ((g & 0x01) << 1);
    Spi.fastWrite(data | 0x924);
    //  r[7:4]  0000abcdxxxx
    //          1a01b01c01d0
    data = ((r & 0x80) << 3) | ((r & 0x40) << 1)
         | ((r & 0x20) >> 1) | ((r & 0x10) >> 3);
    Spi.fastWrite(data | 0x924);
    //  r[3:0]  0000xxxxabcd
    //          1a01b01c01d0
    data = ((r & 0x08) << 7) | ((r & 0x04) << 5)
         | ((r & 0x02) << 3) | ((r & 0x01) << 1);
    Spi.fastWrite(data | 0x924);
    //  b[7:4]  0000abcdxxxx
    //          1a01b01c01d0
    data = ((b & 0x80) << 3) | ((b & 0x40) << 1)
         | ((b & 0x20) >> 1) | ((b & 0x10) >> 3);
    Spi.fastWrite(data | 0x924);
    //  b[3:0]  0000xxxxabcd
    //          1a01b01c01d0
    data = ((b & 0x08) << 7) | ((b & 0x04) << 5)
         | ((b & 0x02) << 3) | ((b & 0x01) << 1);
    Spi.fastWrite(data | 0x924);
}

void Colors::send(unsigned char data[][3]) {
    for (int i = 0; i < num; i++) {
        sendOne(data[i][0], data[i][1], data[i][2]);
    }
    wait_us(50);
}
