#include "mbed.h"
#include "OLEDaccel.h"
#include "image.h"  //  xkozima's image (96x64@24bpp)

OLED display(p16, p14, p15, p11, p13);
AnalogIn ain(p20);

int main() {
    //  radomize
    srand(ain.read_u16());

    //  infinite loop
    while(1) {
        //
        //  caption
        display.text( 0, 12, "Accelerated OLED", display.color(128, 255, 128) );
        display.text( 9, 40, "xkozima (MYU)",    display.color(128, 255, 128));
        display.text(18, 50, "(Aug 2012)",       display.color(128, 255, 128));
        wait_ms(4000);
        display.clear(0);
        //
        //  random rectangles/filled
        for (int k = 0; k < 8; k++) {
            for (int c = 0; c < 32; c++) {
                int cx, cy, x, y, w, h;
                //  center
                cx = rand() % 96;
                cy = rand() % 64;
                //  size
                w = rand() % 30 + 6;
                h = rand() % 20 + 4;
                //  upper-left
                x = cx - w / 2;
                y = cy - h / 2;
                if (x < 0) x = 0;
                if (y < 0) y = 0;
                //  adjust size
                if (x + w > 96) w = 96 - x;
                if (y + h > 64) h = 64 - y;
                //  random color
                int c1 = rand() % 256, c2 = rand() % 256, c3 = rand() % 256;
                //  fill rectangle
                display.rect(x, y, w, h, display.color(c1, c2, c3), 1);
            }
            //  watch the result!
            wait_ms(500);
            display.clear(0);
        }
        //  random rectangles/outlined
        for (int k = 0; k < 8; k++) {
            for (int c = 0; c < 32; c++) {
                int cx, cy, x, y, w, h;
                //  center
                cx = rand() % 96;
                cy = rand() % 64;
                //  size
                w = rand() % 30 + 6;
                h = rand() % 20 + 4;
                //  upper-left
                x = cx - w / 2;
                y = cy - h / 2;
                if (x < 0) x = 0;
                if (y < 0) y = 0;
                //  adjust size
                if (x + w > 96) w = 96 - x;
                if (y + h > 64) h = 64 - y;
                //  random color
                int c1 = rand() % 256, c2 = rand() % 256, c3 = rand() % 256;
                //  draw rectangle
                display.rect(x, y, w, h, display.color(c1, c2, c3), 0);
            }
            //  watch the result!
            wait_ms(500);
            display.clear(0);
        }
        //  random circles/filled
        for (int k = 0; k < 8; k++) {
            for (int c = 0; c < 32; c++) {
                //  coordinates
                int x = rand() % 90 + 3, y = rand() % 60 + 2, r = rand() % 20 + 1;
                if (x - r <  0) r = x;
                if (x + r > 95) r = 95 - x;
                if (y - r <  0) r = y;
                if (y + r > 63) r = 63 - y;
                //  random color
                int c1 = rand() % 256, c2 = rand() % 256, c3 = rand() % 256;
                //  draw line
                display.circle(x, y, r, display.color(c1, c2, c3), 1);
            }
            //  watch the result!
            wait_ms(500);
            display.clear(0);
        }
        //  random circles/outlined
        for (int k = 0; k < 8; k++) {
            for (int c = 0; c < 32; c++) {
                //  coordinates
                int x = rand() % 90 + 3, y = rand() % 60 + 2, r = rand() % 20 + 1;
                if (x - r <  0) r = x;
                if (x + r > 95) r = 95 - x;
                if (y - r <  0) r = y;
                if (y + r > 63) r = 63 - y;
                //  random color
                int c1 = rand() % 256, c2 = rand() % 256, c3 = rand() % 256;
                //  draw line
                display.circle(x, y, r, display.color(c1, c2, c3), 0);
            }
            //  watch the result!
            wait_ms(500);
            display.clear(0);
        }
        //  random ellipses/filled
        for (int k = 0; k < 8; k++) {
            for (int c = 0; c < 32; c++) {
                //  coordinates
                int x = rand() % 90 + 3, y = rand() % 60 + 2, 
                    rx = rand() % 20 + 1, ry = rand() % 20 + 1;
                if (x - rx <  0) rx = x;
                if (x + rx > 95) rx = 95 - x;
                if (y - ry <  0) ry = y;
                if (y + ry > 63) ry = 63 - y;
                //  random color
                int c1 = rand() % 256, c2 = rand() % 256, c3 = rand() % 256;
                //  draw line
                display.ellipse(x, y, rx, ry, display.color(c1, c2, c3), 1);
            }
            //  watch the result!
            wait_ms(500);
            display.clear(0);
        }
        //  random ellipses/outlined
        for (int k = 0; k < 8; k++) {
            for (int c = 0; c < 32; c++) {
                //  coordinates
                int x = rand() % 90 + 3, y = rand() % 60 + 2, 
                    rx = rand() % 20 + 1, ry = rand() % 20 + 1;
                if (x - rx <  0) rx = x;
                if (x + rx > 95) rx = 95 - x;
                if (y - ry <  0) ry = y;
                if (y + ry > 63) ry = 63 - y;
                //  random color
                int c1 = rand() % 256, c2 = rand() % 256, c3 = rand() % 256;
                //  draw line
                display.ellipse(x, y, rx, ry, display.color(c1, c2, c3), 0);
            }
            //  watch the result!
            wait_ms(500);
            display.clear(0);
        }
        //  random lines
        for (int k = 0; k < 8; k++) {
            for (int c = 0; c < 32; c++) {
                //  coordinates
                int x1 = rand() % 96, y1 = rand() % 64, x2 = rand() % 96, y2 = rand() % 64;
                //  random color
                int c1 = rand() % 256, c2 = rand() % 256, c3 = rand() % 256;
                //  draw line
                display.line(x1, y1, x2, y2, display.color(c1, c2, c3));
            }
            //  watch the result!
            wait_ms(500);
            display.clear(0);
        }
        //  random points
        for (int k = 0; k < 8; k++) {
            for (int c = 0; c < 1000; c++) {
                //  coordinates
                int x = rand() % 96, y = rand() % 64;
                //  random color
                int c1 = rand() % 256, c2 = rand() % 256, c3 = rand() % 256;
                //  draw line
                display.point(x, y, display.color(c1, c2, c3));
            }
            //  watch the result!
            wait_ms(500);
            display.clear(0);
        }
        //  random text
        for (int k = 0; k < 8; k++) {
            for (int c = 0; c < 10; c++) {
                //  coordinates
                int x = rand() % (96 - 18), y = rand() % (64 - 8);
                //  text
                char string[4];
                string[0] = 'A' + rand() % 26;
                string[1] = 'a' + rand() % 26;
                string[2] = '0' + rand() % 10;
                string[3] = '\0';
                //  random color
                int c1 = rand() % 256, c2 = rand() % 256, c3 = rand() % 256;
                //  draw text
                display.text(x, y, string, display.color(c1, c2, c3));
            }
            //  watch the result!
            wait_ms(500);
            display.clear(0);
        }
        //  random text (with background)
        for (int k = 0; k < 8; k++) {
            for (int c = 0; c < 10; c++) {
                //  coordinates
                int x = rand() % (96 - 18), y = rand() % (64 - 8);
                //  text
                char string[4];
                string[0] = 'A' + rand() % 26;
                string[1] = 'a' + rand() % 26;
                string[2] = '0' + rand() % 10;
                string[3] = '\0';
                //  random color
                int f1 = rand() % 256, f2 = rand() % 256, f3 = rand() % 256;
                int b1 = rand() % 256, b2 = rand() % 256, b3 = rand() % 256;
                //  draw text
                display.text(x, y, string, display.color(f1, f2, f3), display.color(b1, b2, b3));
            }
            //  watch the result!
            wait_ms(500);
            display.clear(0);
        }
        //
        //  slow to fast (rectangles/filled)
        int usec = 1000000;
        for (int cc = 0; cc < 14; cc++) {
            usec /= 2;
            int count = 1000000 / usec;
            //  random rects
            for (int c = 0; c < count; c++) {
                int cx, cy, x, y, w, h;
                //  center
                cx = rand() % 96;
                cy = rand() % 64;
                //  size
                w = rand() % 60 + 3;
                h = rand() % 40 + 2;
                //  upper-left
                x = cx - w / 2;
                y = cy - h / 2;
                if (x < 0) x = 0;
                if (y < 0) y = 0;
                //  adjust size
                if (x + w > 96) w = 96 - x;
                if (y + h > 64) h = 64 - y;
                //  random color
                int c1 = rand() % 256, c2 = rand() % 256, c3 = rand() % 256;
                //  fill rectangle
                display.rect(x, y, w, h, display.color(c1, c2, c3), 1);
                //  wait (slow to fast)
                wait_us(usec);
            }
        }
        wait_ms(2000);
        display.clear(0);
        //  slow to fast (rectangles/outlined)       
        usec = 1000000;
        for (int cc = 0; cc < 14; cc++) {
            usec /= 2;
            int count = 1000000 / usec;
            //  random rects
            for (int c = 0; c < count; c++) {
                int cx, cy, x, y, w, h;
                //  center
                cx = rand() % 96;
                cy = rand() % 64;
                //  size
                w = rand() % 60 + 3;
                h = rand() % 40 + 2;
                //  upper-left
                x = cx - w / 2;
                y = cy - h / 2;
                if (x < 0) x = 0;
                if (y < 0) y = 0;
                //  adjust size
                if (x + w > 96) w = 96 - x;
                if (y + h > 64) h = 64 - y;
                //  random color
                int c1 = rand() % 256, c2 = rand() % 256, c3 = rand() % 256;
                //  draw rectangle
                display.rect(x, y, w, h, display.color(c1, c2, c3), 0);
                //  wait (slow to fast)
                wait_us(usec);
            }
        }
        wait_ms(2000);
        display.clear(0);
        //  slow to fast (circles/filled)    
        usec = 1000000;
        for (int cc = 0; cc < 12; cc++) {
            usec /= 2;
            int count = 1000000 / usec;
            //  random circles
            for (int c = 0; c < count; c++) {
                //  coordinates
                int x = rand() % 90 + 3, y = rand() % 60 + 2, r = rand() % 20 + 1;
                if (x - r <  0) r = x;
                if (x + r > 95) r = 95 - x;
                if (y - r <  0) r = y;
                if (y + r > 63) r = 63 - y;
                //  random color
                int c1 = rand() % 256, c2 = rand() % 256, c3 = rand() % 256;
                //  draw circle
                display.circle(x, y, r, display.color(c1, c2, c3), 1);
                //  wait (slow to fast)
                wait_us(usec);
            }
        }
        wait_ms(2000);
        display.clear(0);
        //  slow to fast (circles/outlined)    
        usec = 1000000;
        for (int cc = 0; cc < 12; cc++) {
            usec /= 2;
            int count = 1000000 / usec;
            //  random circles
            for (int c = 0; c < count; c++) {
                //  coordinates
                int x = rand() % 90 + 3, y = rand() % 60 + 2, r = rand() % 20 + 1;
                if (x - r <  0) r = x;
                if (x + r > 95) r = 95 - x;
                if (y - r <  0) r = y;
                if (y + r > 63) r = 63 - y;
                //  random color
                int c1 = rand() % 256, c2 = rand() % 256, c3 = rand() % 256;
                //  draw cirlce
                display.circle(x, y, r, display.color(c1, c2, c3), 0);
                //  wait (slow to fast)
                wait_us(usec);
            }
        }
        wait_ms(2000);
        display.clear(0);
        //  slow to fast (ellipses/filled)    
        usec = 1000000;
        for (int cc = 0; cc < 12; cc++) {
            usec /= 2;
            int count = 1000000 / usec;
            //  random circles
            for (int c = 0; c < count; c++) {
                //  coordinates
                int x = rand() % 90 + 3, y = rand() % 60 + 2, 
                    rx = rand() % 20 + 1, ry = rand() % 20 + 1;
                if (x - rx <  0) rx = x;
                if (x + rx > 95) rx = 95 - x;
                if (y - ry <  0) ry = y;
                if (y + ry > 63) ry = 63 - y;
                //  random color
                int c1 = rand() % 256, c2 = rand() % 256, c3 = rand() % 256;
                //  draw line
                display.ellipse(x, y, rx, ry, display.color(c1, c2, c3), 1);
                //  wait (slow to fast)
                wait_us(usec);
            }
        }
        wait_ms(2000);
        display.clear(0);
        //  slow to fast (ellipses/outlined)    
        usec = 1000000;
        for (int cc = 0; cc < 12; cc++) {
            usec /= 2;
            int count = 1000000 / usec;
            //  random circles
            for (int c = 0; c < count; c++) {
                //  coordinates
                int x = rand() % 90 + 3, y = rand() % 60 + 2, 
                    rx = rand() % 20 + 1, ry = rand() % 20 + 1;
                if (x - rx <  0) rx = x;
                if (x + rx > 95) rx = 95 - x;
                if (y - ry <  0) ry = y;
                if (y + ry > 63) ry = 63 - y;
                //  random color
                int c1 = rand() % 256, c2 = rand() % 256, c3 = rand() % 256;
                //  draw line
                display.ellipse(x, y, rx, ry, display.color(c1, c2, c3), 0);
                //  wait (slow to fast)
                wait_us(usec);
            }
        }
        wait_ms(2000);
        display.clear(0);
        //  slow to fast (lines)    
        usec = 1000000;
        for (int cc = 0; cc < 14; cc++) {
            usec /= 2;
            int count = 1000000 / usec;
            //  random lines
            for (int c = 0; c < count; c++) {
                //  coordinates
                int x1 = rand() % 96, y1 = rand() % 64, x2 = rand() % 96, y2 = rand() % 64;
                //  random color
                int c1 = rand() % 256, c2 = rand() % 256, c3 = rand() % 256;
                //  draw line
                display.line(x1, y1, x2, y2, display.color(c1, c2, c3));
                //  wait (slow to fast)
                wait_us(usec);
            }
        }
        wait_ms(2000);
        display.clear(0);
        wait_ms(1000);
        //  slow to fast (points)    
        usec = 200000;
        for (int cc = 0; cc < 18; cc++) {
            usec /= 2;
            int count = 200000 / usec;
            //  random lines
            for (int c = 0; c < count; c++) {
                //  coordinates
                int x = rand() % 96, y = rand() % 64;
                //  random color
                int c1 = rand() % 256, c2 = rand() % 256, c3 = rand() % 256;
                //  draw line
                display.point(x, y, display.color(c1, c2, c3));
                //  wait (slow to fast)
                wait_us(usec);
            }
        }
        wait_ms(2000);
        display.clear(0);
        wait_ms(1000);
        //
        //  slow to fast (text)    
        usec = 1000000;
        for (int cc = 0; cc < 12; cc++) {
            usec /= 2;
            int count = 1000000 / usec;
            //  random text
            for (int c = 0; c < count; c++) {
                //  coordinates
                int x = rand() % (96 - 18), y = rand() % (64 - 8);
                //  text
                char string[4];
                string[0] = 'A' + rand() % 26;
                string[1] = 'a' + rand() % 26;
                string[2] = '0' + rand() % 10;
                string[3] = '\0';
                //  random color
                int c1 = rand() % 256, c2 = rand() % 256, c3 = rand() % 256;
                //  draw text
                display.text(x, y, string, display.color(c1, c2, c3));
                //  wait (slow to fast)
                wait_us(usec);
            }
        }
        wait_ms(2000);
        display.clear(0);        
        //
        //  slow to fast (text with background)    
        usec = 1000000;
        for (int cc = 0; cc < 12; cc++) {
            usec /= 2;
            int count = 1000000 / usec;
            //  random text
            for (int c = 0; c < count; c++) {
                //  coordinates
                int x = rand() % (96 - 18), y = rand() % (64 - 8);
                //  text
                char string[4];
                string[0] = 'A' + rand() % 26;
                string[1] = 'a' + rand() % 26;
                string[2] = '0' + rand() % 10;
                string[3] = '\0';
                //  random color
                int f1 = rand() % 256, f2 = rand() % 256, f3 = rand() % 256;
                int b1 = rand() % 256, b2 = rand() % 256, b3 = rand() % 256;
                //  draw text
                display.text(x, y, string, display.color(f1, f2, f3), display.color(b1, b2, b3));
                //  wait (slow to fast)
                wait_us(usec);
            }
        }
        wait_ms(2000);
        display.clear(0);        
        //
        //  checker 32x32
        for (int yy = 0; yy < 2; yy++) {
            int col = yy;
            for (int xx = 0; xx < 3; xx++) {
                display.rect(xx * 32, yy * 32, 32, 32, 
                             (col++ % 2)? display.color(255, 0, 0): 
                                          display.color(255, 255, 255), 
                             1 );
                //wait_us(32*32/10);
            }
        }
        wait_ms(1000);
        //  checker 16x16
        for (int yy = 0; yy < 4; yy++) {
            int col = yy;
            for (int xx = 0; xx < 6; xx++) {
                display.rect(xx * 16, yy * 16, 16, 16, 
                             (col++ % 2)? display.color(255, 0, 0): 
                                          display.color(255, 255, 255), 
                             1 );
                //wait_us(16*16/10);
            }
        }
        wait_ms(1000);
        //  checker 8x8
        for (int yy = 0; yy < 8; yy++) {
            int col = yy;
            for (int xx = 0; xx < 12; xx++) {
                display.rect(xx * 8, yy * 8, 8, 8, 
                             (col++ % 2)? display.color(255, 0, 0): 
                                          display.color(255, 255, 255), 
                             1 );
                //wait_us(8*8/10);
            }
        }
        wait_ms(1000);
        //  checker 4x4
        for (int yy = 0; yy < 16; yy++) {
            int col = yy;
            for (int xx = 0; xx < 24; xx++) {
                display.rect(xx * 4, yy * 4, 4, 4, 
                             (col++ % 2)? display.color(255, 0, 0): 
                                          display.color(255, 255, 255), 
                             1 );
                //wait_us(4*4/10);
            }
        }
        wait_ms(1000);
        //  checker 2x2
        for (int yy = 0; yy < 32; yy++) {
            int col = yy;
            for (int xx = 0; xx < 48; xx++) {
                display.rect(xx * 2, yy * 2, 2, 2, 
                             (col++ % 2)? display.color(255, 0, 0): 
                                          display.color(255, 255, 255), 
                             1 );
                //wait_us(1);
            }
        }
        wait_ms(1000);
        //  checker 1x1
        for (int yy = 0; yy < 64; yy++) {
            int col = yy;
            for (int xx = 0; xx < 96; xx++) {
                display.rect(xx * 1, yy * 1, 1, 1, 
                             (col++ % 2)? display.color(255, 0, 0): 
                                          display.color(255, 255, 255), 
                             1 );
                //wait_us(1);
            }
        }
        wait_ms(1000);
        display.clear(0);
        wait_ms(1000);
        //
        //  draw image
        display.image(0, 0, 96, 64, image8x3);
        wait_ms(2000);
        //  scroll image
        for (int yyy = 0; yyy < 64; yyy++) {
            display.image(0, 0, 96, yyy + 1, image8x3 + ((63 - yyy) * 96) * 3 );
            display.image(0, yyy + 1, 96, 63 - yyy, image8x3 );
        }
        wait_ms(2000);
        display.clear(0);
        wait_ms(1000);   
    }   
}
