//
//  OLEDaccel: 96x64 OLED driver
//  (version 0.2, August 15, 2012)
//  xkozima@myu.ac.jp

#pragma once
#include "mbed.h"

class OLED {
public:
    OLED(PinName rstPin, PinName csPin, PinName dcPin, PinName mosiPin, PinName sckPin);
    void clear(unsigned short color);
    void point(int x, int y, unsigned short color);
    void line(int x1, int y1, int x2, int y2, unsigned short color);
    void rect(int x, int y, int w, int h, unsigned short color, int fill);
    void circle(int x, int y, int r, unsigned short color, int fill);
    void ellipse(int x, int y, int rx, int ry, unsigned short color, int fill);
    void image(int x, int y, int w, int h, unsigned short *image16);
    void image(int x, int y, int w, int h, const unsigned short *image16);
    void image(int x, int y, int w, int h, unsigned char *image8x3);
    void image(int x, int y, int w, int h, const unsigned char *image8x3);
    void text(int x, int y, char *string, unsigned short color);
    void text(int x, int y, char *string, unsigned short colorF, unsigned short colorB);
    unsigned short color(int r, int g, int b);
private:
    void cmdOutOne(unsigned char cmdOne);
    void cmdOut(unsigned char *cmd, int length);
    void dataOut(unsigned short *data, int length);
    DigitalOut rst, cs, dc;
    SPI spi;
    bool reversal;
    bool filling;
};