#include "mbed.h"
#include "TCS3472_I2C.h"
#include "VL6180.h"
DigitalOut distance_over(p24);
DigitalOut start_Digital_Tube(p15);
DigitalOut start_LED(p16);
DigitalOut start_question1(p18);
DigitalOut start_question2(p19);
DigitalIn result1_led(p7);
DigitalIn result2_led(p8);
DigitalIn result1_Digital_Tube(p11);
DigitalIn result2_Digital_Tube(p12);
DigitalIn result1_question(p13);
DigitalIn result2_question(p14);
VL6180 TOF_sensor(p28, p27);
TCS3472_I2C rgb_sensor(p9, p10);
DigitalOut color1(p21);
DigitalOut color2(p22);
DigitalOut start_good_supply(p17);
DigitalIn color_over(p23);
DigitalOut servo_test(p20);
DigitalIn infrared1(p25);
DigitalIn infrared3(p26);
DigitalIn infrared2(p29);
DigitalIn infrared4(p30);


Serial      pc(USBTX, USBRX);

int main()
{
    int game_count;
    int distance_count;
    int good_shut_down;
    int Digital_Tube,LED,QUESTION1,QUESTION2;
    uint8_t dist;       //distance
    int count_color;
    char a;
    float R,G,B;
    TOF_sensor.VL6180_Init();
    int rgb_readings[4];    //color
    int user,maintance;
    rgb_sensor.enablePowerAndRGBC();
    rgb_sensor.setIntegrationTime(100);
while(1)
{
    Digital_Tube=0;
    LED=0;
    QUESTION1=0;
    QUESTION2=0;
    start_Digital_Tube=0;
    start_LED=0;
    start_question1=0;
    start_question2=0;
    start_good_supply=0;
    servo_test=0;
    color1=0;
    color2=0;
    good_shut_down=0;
    distance_over=0;
    distance_count=0;
    game_count=0;
    
    while(1)
    {
        a=pc.getc();
        if(a=='9')
        {
            break;
        }
    }

    while(1) 
    {
        dist = TOF_sensor.getDistance();        //always reading the data of distance
        if(dist>=100 && dist<255)
        {
            distance_over=0;
            pc.printf("10");
            break;
        }
        else
        {
            distance_over=1;
        }
    }
    while(1)
    {
        a=pc.getc();
        if(a=='2') //if the mbed get the signal to read card
        {
            while(1)
            {
                //identify the card
                if(infrared1==1 && infrared2==1 && infrared3==1 && infrared4==1)
                {
                    user=0;
                    maintance=1;
                    pc.printf("0");
                    break;
                }
                else
                {
                    user=1;
                    maintance=0;
                    pc.printf("1");
                    break;
                }
            }
            break;
        }
        if(a=='7')
        {
            break;
        }
    }
    while(user==1 && maintance==0)
    {
        while(1)
        {
            a=pc.getc();
            if(a=='7')
            {
                break;
            }
            if(a=='8')
            {
                Digital_Tube=1;
                break;
            }
            if(a=='9')
            {
                LED=1;
                break;
            }
            if(a=='5')
            {
                QUESTION1=1;
                break;
            }
            if(a=='6')
            {
                QUESTION2=1;
                break;
            }
        }
        if(Digital_Tube==1 && LED==0 && QUESTION1==0 && QUESTION2==0)
        {
            start_Digital_Tube=1;
            while(1) 
            {
                game_count=game_count+1;
                dist = TOF_sensor.getDistance();
                if(dist<=100 || dist>=200)
                {
                    distance_over=1;
                    distance_count=distance_count+1;
                    if(distance_count==1000)
                    {
                        break;
                    }
                }
                else
                {
                    distance_over=0;
                    distance_count=0;
                }
                if(result1_Digital_Tube==1 && result2_Digital_Tube==0) 
                {
                    pc.printf("1");
                    start_Digital_Tube=0;
                    break;
                }
                if(result1_Digital_Tube==0 && result2_Digital_Tube==1) 
                {
                    pc.printf("0");
                    start_Digital_Tube=0;
                    break;
                }
                if(game_count==4000)
                {
                    game_count=0;
                    pc.printf("long time without operating");
                    break;
                }  
            }
        }
        if(Digital_Tube==0 && LED==1 && QUESTION1==0 && QUESTION2==0)
        {
            start_LED=1;
            while(1) 
            {
                game_count=game_count+1;
                dist = TOF_sensor.getDistance();
                if(dist<=100 || dist>=200)
                {
                    distance_over=1;
                    distance_count=distance_count+1;
                    if(distance_count==1000)
                    {
                        break;
                    }
                }
                else
                {
                    distance_over=0;
                    distance_count=0;
                }
                if(result1_led==1 && result2_led==0) 
                {
                    pc.printf("1");
                    start_LED=0;
                    break;
                }
                if(result1_led==0 && result2_led==1) 
                {
                    pc.printf("0");
                    start_LED=0;
                    break;
                }
                if(game_count==4000)
                {
                    game_count=0;
                    pc.printf("long time without operating");
                    break;
                } 
            }
        }
        if(Digital_Tube==0 && LED==0 && QUESTION1==1 && QUESTION2==0)
        {
            start_question1=1;
            start_question2=0;
            while(1) 
            {
                game_count=game_count+1;
                dist = TOF_sensor.getDistance();
                if(dist<=100 && dist>=200)
                {
                    distance_over=1;
                    distance_count=distance_count+1;
                    if(distance_count==1000)
                    {
                        break;
                    }
                }
                else
                {
                    distance_over=0;
                    distance_count=0;
                }
                if(result1_question==1 && result2_question==0) 
                {
                    pc.printf("1");
                    start_question1=0;
                    break;
                }
                if(result1_question==0 && result2_question==1) 
                {
                    pc.printf("0");
                    start_question1=0;
                    break;
                }
                if(game_count==4000)
                {
                    game_count=0;
                    pc.printf("long time without operating");
                    break;
                }
            }
        }
        if(Digital_Tube==0 && LED==0 && QUESTION1==0 && QUESTION2==1)
        {
            start_question1=0;
            start_question2=1;
            while(1) 
            {
                game_count=game_count+1;
                dist = TOF_sensor.getDistance();
                if(dist<=100 || dist>=200)
                {
                    distance_over=1;
                    distance_count=distance_count+1;
                    if(distance_count==1000)
                    {
                        break;
                    }
                }
                else
                {
                    distance_over=0;
                    distance_count=0;
                }
                if(result1_question==1 && result2_question==0) 
                {
                    pc.printf("1");
                    start_question1=0;
                    start_question2=0;
                    break;
                }
                if(result1_question==0 && result2_question==1) 
                {
                    pc.printf("0");
                    start_question1=0;
                    start_question2=0;
                    break;
                }
                if(game_count==4000)
                {
                    game_count=0;
                    pc.printf("long time without operating");
                    break;
                } 
            }
        }
        break;
    }
    while(user==0 && maintance==1)
    {
        a=pc.getc();
        if(a=='3')
        {
            start_Digital_Tube=1;
            start_LED=1;
            start_question1=1;
            wait(10);
            start_Digital_Tube=0;
            start_LED=0;
            start_question1=0;
        }
        if(a=='4')
        {
            servo_test=1;
            wait(10);
            servo_test=0;
        }
        if(a=='5')
        {
            dist = TOF_sensor.getDistance(); 
            rgb_sensor.getAllColors(rgb_readings);
            pc.printf("The distance are %d and the color are Red %d     Green %d    Blue %d\n",dist,rgb_readings[1],rgb_readings[2],rgb_readings[3]);
        }
        if(a=='6')
        {
            while(1) 
            {
                count_color=0;
                R=0;
                G=0;
                B=0;
                color1=0;
                color2=0;
                start_good_supply=0;
                while(1) 
                {
                    count_color=count_color+1;
                    rgb_sensor.getAllColors(rgb_readings);
                    R=R+rgb_readings[1];
                    G=G+rgb_readings[2];
                    B=B+rgb_readings[3];
                    if(count_color>=10) 
                    {
                        R=R/10;
                        G=G/10;
                        B=B/10;
                        break;
                    }
                }
                start_good_supply=1;
                if((R-B)>=100 && (G-B)>=100 && R>G) 
                {
                    color1=0;
                    color2=1;
                    while(1) 
                    {
                        if(color_over==1) 
                        {
                            start_good_supply=0;
                            wait(2);
                            break;
                        }
                    }
                } 
                else if((R-B)>=100 && (R-G)>=100 && (G-B)<=100) 
                {
                    color1=1;
                    color2=0;
                    while(1) 
                    {
                        if(color_over==1) 
                        {
                            start_good_supply=0;
                            wait(2);
                            break;
                        }
                    }
                } 
                else if((G-R)>=70 && (G-B)>=100) 
                {
                    color1=1;
                    color2=1;
                    while(1) 
                    {
                        if(color_over==1) 
                        {
                            start_good_supply=0;
                            wait(2);
                            break;
                        }
                    }
                } 
                else
                {
                    good_shut_down=good_shut_down+1;
                    if(good_shut_down==5)
                    {
                        good_shut_down=0;
                        break;
                    }
                }
            }
        }
        if(a=='7')
        {
            break;
        }
            
    }
}
            
}
