#include<mbed.h>

 
DigitalOut LED_R(P0_20);
DigitalOut LED_G(P0_19);

#include "BMP180.h"
I2C i2c(P0_17,P0_18);
BMP180 bmp180(&i2c);

Serial pc(P0_23,P0_25);

void bmp180_test(void)
{
    float temp;
    int press;
    
    if(bmp180.init() != 0)
    {
        pc.printf("bmp180 init failed.\r\n");
        return;
    }
    
    bmp180.startTemperature();
    bmp180.startPressure(BMP180::ULTRA_LOW_POWER);
    
    while(1)
    {
        wait_ms(1000);
        if(bmp180.getTemperature(&temp) == 0)
            pc.printf("current temperature:%.2f\t",temp);
        else
        {
            pc.printf("bmp180 read temperature failed\r\n");
            break;
        }
        
        if(bmp180.getPressure(&press) == 0)
            pc.printf("current pressure:%d\r\n",press);
        else
        {
            pc.printf("bmp180 read pressure failed.\r\n");
            break;
        }
    }
}

 int main()
 {
     LED_G = 1; 
     
     pc.printf("Hello,Mbed!\r\n");
     
     bmp180_test();
     
     while(1)
     {
         LED_R=1;
         //LED_G=1;
         wait(0.5);
         LED_R=0;
         //LED_G=0;
         wait(0.5);
     } 
 }