#include "ReportThread.h"
#include "logging.h"

static const char *fmt2 = "111,%ld,%s\r\n";

void ReportThread::threadFunc()
{
    while (true) {
        dict.clear();
        osEvent e = ipool.get();
        if (e.status == osEventMail) {
            Operation *op = (Operation*)e.value.p;
            dict.set(op->identifier, op->state);
            ipool.free(op);
            while (!dict.full()) {
                osEvent e = ipool.get(200);
                if (e.status == osEventMail) {
                    op = (Operation*)e.value.p;
                    dict.set(op->identifier, op->state);
                    ipool.free(op);
                } else {
                    break;
                }
            }
            int l = 0;
            for (unsigned short i = 0; i < dict.size(); ++i) {
                const long id = dict[i].identifier;
                const OperationState state = dict[i].state;
                l += snprintf(buf2+l, sizeof(buf2)-l, fmt2, id, strOperationState(state));
            }
            l = snprintf(buf, sizeof(buf), fmtSmartRest, uri, l, buf2);
            for (unsigned i = 0; i < 3; ++i) {
                sock.setBlocking(3000);
                int l2 = sock.sendOnly(buf, l);
                if (l2 < 0) {
                    aError("Report: op state\n");
                    Thread::wait(3000);
                } else {
                    break;
                }
            }
        }
    }
}
