#include <string.h>
#include "OperationSupport.h"
//#include "ComposedRecord.h"
//#include "ParsedRecord.h"
//#include "IntegerValue.h"
#include "SmartRestSocket.h"
#include "ControlParser.h"
#include "logging.h"

bool OperationSupport::init()
{
    if (_init)
        return false;
    
    // Get pending operations
    // USAGE: 110,<DEVICE/ID>
    if (!_tpl.add("10,110,GET,/devicecontrol/operations?status=PENDING&deviceId=%%&pageSize=100,,application/vnd.com.nsn.cumulocity.operationCollection+json,%%,UNSIGNED,\r\n"))
        return false;

    // Set operation state
    // USAGE: 111,<OPERATION/ID>,<STATE>
    if (!_tpl.add("10,111,PUT,/devicecontrol/operations/%%,application/vnd.com.nsn.cumulocity.operation+json,application/vnd.com.nsn.cumulocity.operation+json,%%,UNSIGNED STRING,\"{\"\"status\"\":\"\"%%\"\"}\"\r\n"))
        return false;

    // Get operations
    // Response: 210,<OPERATION/ID>,<STATUS>
    if (!_tpl.add("11,210,\"$.operations\",,\"$.id\",\"$.status\"\r\n"))
        return false;

    // Get operation
    // Response: 211,<OPERATION/ID>,<STATUS>
    if (!_tpl.add("11,211,,\"$.deviceId\",\"$.id\",\"$.status\"\r\n"))
        return false;
        
    // Get operation by id
    // USAGE: 112,<OPERATION/ID>
    if (!_tpl.add("10,112,GET,/devicecontrol/operations/%%,,application/vnd.com.nsn.cumulocity.operation+json,%%,UNSIGNED,\r\n"))
        return false;

    // Relay operation response
    // Response: 220,<OPERATION/ID>,<STATUS>
    if (!_tpl.add("11,220,,\"$.c8y_Relay\",\"$.id\",\"$.c8y_Relay.relayState\"\r\n"))
        return false;

    // Message operation response
    // Response: 221,<OPERATION/ID>,<MESSAGE>
    if (!_tpl.add("11,221,,\"$.c8y_Message\",\"$.id\",\"$.c8y_Message.text\"\r\n"))
        return false;

    // Configuration operation response
    // Response: 222,<OPERATION/ID>,<CONFIGURATION/STRING>
    if (!_tpl.add("11,222,,\"$.c8y_Configuration\",\"$.id\",\"$.c8y_Configuration.config\"\r\n"))
        return false;

    _init = true;
    return true;
}

bool OperationSupport::executePendingOperations()
{
        char buf[SMARTREST_SIZE];
        char buf2[SMARTREST_BODY_SIZE];
        SmartRestSocket sock;
        int l = snprintf(buf2, sizeof(buf2), "110,%ld\r\n", deviceID);
        l = snprintf(buf, sizeof(buf), fmtSmartRest, "/s", l, buf2);
        l = sock.sendAndReceive(buf, l, sizeof(buf));
        if (l < 0) {
                aError("Retrieve pending operations\n");
                return false;
        }
        const size_t N = 10;
        long opl[N];
        size_t i = 0;
        for (const char* p = skipHTTPHeader(buf); i<N && *p;) {
                long id = 0;
                int c = 0;
                int n = sscanf(p, "210,1,%ld,PENDING\r\n%n", &id, &c);
                if (n == 1) {
                        opl[i++] = id;
                        p += c;
                } else
                        break;
        }
        if (i == 0)
                return true;
        else if (i >= N)
                aWarning("Over %u pending operations.\n", N);
        ControlParser cp(opool);
        bool flag = true;
        l = 0;
        for (size_t j = 0; j < i; ++j) {
                l += snprintf(buf2+l, sizeof(buf2)-l, "112,%ld\r\n", opl[j]);
        }
        l = snprintf(buf, sizeof(buf), fmtSmartRest, "/s", l, buf2);
        l = sock.sendAndReceive(buf, l, sizeof(buf));
        if (l >= 0)
                cp.parse(buf);
        else
                flag = false;
        return flag;
}