#ifndef TEMPERATURE_H
#define TEMPERATURE_H
#include "mbed.h"
#include "LM75B.h"
#include "AbstractReporter.h"


class Temperature: public AbstractReporter
{
public:
        Temperature(): deviceReady(false), oldValue(0),
                timer(), sensor(D14, D15) {
                timer.start();
        }
        virtual ~Temperature() {}
        virtual bool init() {
                deviceReady = sensor.open();
                return deviceReady;
        }
        virtual const char* name() const { return "Temp"; }
        virtual int read(char*, size_t, char*, size_t);
private:
        bool deviceReady;
        float oldValue;
        Timer timer;
        LM75B sensor;
};

#endif /* TEMPERATURE_H */