#ifndef LCDDISPLAY_H
#define LCDDISPLAY_H
#include <string.h>
#include "C12832.h"
#include "rtos.h"
#define DISPLAY_LEN 27

class LCDDisplay
{
private:
        LCDDisplay(): firstLine(""), secondLine(""), thirdLine(""),
                      _lcd(D11, D13, D12, D7, D10) {}
        LCDDisplay(LCDDisplay const&);
        void operator=(LCDDisplay const&);
public:
        static LCDDisplay& inst() {
                static LCDDisplay _ref;
                return _ref;
        }
        void setFirstLine(const char* p);
        const char *getFirstLine() const { return firstLine; }
        void setSecondLine(const char* p);
        const char *getSecondLine() const { return secondLine; }
        void setThirdLine(const char* p);
        const char *getThirdLine() const { return thirdLine; }
        void setLines(const char *p1, const char *p2=NULL, const char *p3=NULL);
        void clear();
        virtual ~LCDDisplay() {}

protected:
        void lcdPrint(const char*, const char* = NULL, const char* = NULL);
        void _setLine(char *dest, const char* src, size_t n);

private:
        char firstLine[DISPLAY_LEN];
        char secondLine[DISPLAY_LEN];
        char thirdLine[DISPLAY_LEN];
        C12832 _lcd;
        Mutex lcdLock;
};

#endif /* LCDDISPLAY_H */
