#include <string.h>
#include "SmartRestSocket.h"
#include "SmartRestConf.h"


int SmartRestSocket::connect()
{
        extern MDMSerial *pMdm;
        int n = -1;
        for (size_t i = 0; i < 3; ++i) {
                if (cachedIP[0] == 0) {
                        MDMParser::IP ip = pMdm->gethostbyname(srHost);
                        if (ip == NOIP)
                                continue;
                        const unsigned char *c = (const unsigned char*)&ip;
                        snprintf(cachedIP, sizeof(cachedIP), "%u.%u.%u.%u", c[3], c[2], c[1], c[0]);
                }
                n = TCPSocketConnection::connect(cachedIP, srPort);
                if (n == 0) {
                        break;
                } else {
                        cachedIP[0] = 0;
                }
        }
        return n;
}

int SmartRestSocket::sendOnly(char *buf, int size)
{
        int l = connect();
        if (l < 0) {
                close();
                return -3;
        }
        l = send(buf, size);
        close();
        if (l < 0) {
                return -2;
        } else {
                return l;
        }
}

int SmartRestSocket::sendAndReceive(char *buf, int size, int maxSize)
{
        int l = connect();
        if (l < 0) {
                close();
                return -3;
        }
        l = send(buf, size);
        if (l < 0) {
                close();
                return -2;
        } else {
                l = receive(buf, maxSize);
                close();
                if (l >= 0 && l < maxSize)
                        buf[l] = 0;
                return l;
        }
}