#include <stdio.h>
#include <string.h>
#include "MDM.h"

#define CREDENTIALS_FILE "001_CREDENTIALS"
#define CONFIGURATION_FILE "002_CONFIGURATION"
extern MDMSerial *pMdm;

bool loadCredential(char *tenant, char *username, char *password, size_t len)
{
    char buffer[len*3+3];
    int res = pMdm->readFile(CREDENTIALS_FILE, buffer, sizeof(buffer));
    if (res <= 0) {
        return false;
    } else {
        buffer[res] = 0;
        int l = sscanf(buffer, "%[^/]/%s\n%s\n", tenant, username, password);
        return l==3;
    }
}

bool resetCredential()
{
    return pMdm->delFile(CREDENTIALS_FILE);
}

bool saveCredential(const char *tenant, const char *username,
                    const char *password, size_t len)
{
    char buffer[len*3+3];
    int res = snprintf(buffer, sizeof(buffer), "%s/%s\n%s\n", tenant, username, password);
    pMdm->delFile(CREDENTIALS_FILE);
    return pMdm->writeFile(CREDENTIALS_FILE, buffer, res)==res;
}

int loadConfigFile(char *cfg, size_t len)
{
    int res = pMdm->readFile(CONFIGURATION_FILE, cfg, len);
    if (res >= 0)
        cfg[res] = 0;
    return res;
}

bool saveConfigFile(char *cfg, size_t len)
{
    pMdm->delFile(CONFIGURATION_FILE);
    return pMdm->writeFile(CONFIGURATION_FILE, cfg, len)==len;
}
