#include <string.h>
#include "ConfigParser.h"
#include "logging.h"

bool ConfigParser::parse(const char *buf)
{
        if (buf == NULL) return false;
        Token tok;
        ptrPF = &ConfigParser::parseKey;
        parseOK = true;
        dict.clear();
        for (const char*p = buf; *p;) {
                p = lexConfig(p, tok);
                (this->*ptrPF)(tok);
        }
        return parseOK;
}

void ConfigParser::parseKey(Token& tok)
{
        if (tok.type == Token::STRING) {
                memset(key, 0, MAX_KEY_LEN);
                size_t num = tok.len<MAX_VALUE_LEN ? tok.len : MAX_VALUE_LEN;
                strncpy(key, tok.p, num);
                ptrPF = &ConfigParser::parseAssignOp;
        } else {
                parseError(tok);
        }
}

void ConfigParser::parseAssignOp(Token& tok)
{
        if (tok.type == Token::ASSIGN) {
                ptrPF = &ConfigParser::parseValue;
        } else {
                parseError(tok);
        }
}

void ConfigParser::parseValue(Token& tok)
{
        if (tok.type != Token::NONE) {
                memset(value, 0, MAX_VALUE_LEN);
                size_t num = tok.len<MAX_VALUE_LEN ? tok.len : MAX_VALUE_LEN;
                strncpy(value, tok.p, num);
                dict.set(key, value);
                ptrPF = &ConfigParser::parseSemiColon;
        } else {
                parseError(tok);
        }
}

void ConfigParser::parseSemiColon(Token& tok)
{
        if (tok.type == Token::SEMICOLON) {
                ptrPF = &ConfigParser::parseKey;
        } else {
                parseError(tok);
        }
}

void ConfigParser::parseError(Token& tok)
{
        parseOK = false;
        aError("ConfParse: (%d) %.*s\n", tok.type, (int)tok.len, tok.p);
        parseRecover(tok);
}

void ConfigParser::parseRecover(Token& tok)
{
        if (tok.type == Token::SEMICOLON) {
                ptrPF = &ConfigParser::parseKey;
        } else {
                ptrPF = &ConfigParser::parseRecover;
        }
}
