#include <string.h>
#include <stdio.h>
#include "b64.h"
#include "SmartRestConf.h"

char srTenant[CREDENTIAL_LENGTH] = {0};
char srUsername[CREDENTIAL_LENGTH] = {0};
char srPassword[CREDENTIAL_LENGTH] = {0};
char srAuthStr[100] = {0};
//const char *srX_ID = "com_cumulocity_MbedAgent_1.5.2";
const char *srX_ID = NULL;
const char *srHost = "developer.cumulocity.com";
//const char *srHost = "iot.etisalat.eg";
//const char *srHost = "management.teleena-iot.com";
//const char *srHost = "post-iot.lu";
//const char *srHost = "dev-a.cumulocity.com";
//const char *srHost = "dev-c.cumulocity.com";
//const char *srHost = "management.m2m-devicecloud.com";
long deviceID = 0;
char fmtSmartRest[200] = {0};

static void setAuthStr(const char* p1, const char* p2)
{
        memset(srAuthStr, 0, sizeof(srAuthStr));
        size_t ul = strlen(p1);
        size_t pl = strlen(p2);
        unsigned char input[3], output[5];
        int inputOffset = 0;

        for (size_t i = 0; i < (ul+1+pl); i++) {
                if (i < ul)
                        input[inputOffset++] = p1[i];
                else if (i == ul)
                        input[inputOffset++] = ':';
                else
                        input[inputOffset++] = p2[i-(ul+1)];

                if ((inputOffset == 3) || (i == ul+pl)) {
                        b64_encode(input, inputOffset, output, 4);
                        output[4] = '\0';
                        strcat(srAuthStr, (char*)output);
                        inputOffset = 0;
                }
        }
}

static void setTenant(const char *tenant)
{
        snprintf(srTenant, sizeof(srTenant), "%s", tenant);
}

static void setUsername(const char *username)
{
        snprintf(srUsername, sizeof(srUsername), "%s", username);
}

static void setPassword(const char *password)
{
        snprintf(srPassword, sizeof(srPassword), "%s", password);
}

static void setSmartRestFmt()
{
        if (srX_ID) {
                const char fmt[] = "POST %%s HTTP/1.0\r\nHost: %s\r\nAuthorization: Basic %s\r\nX-Id: %s\r\nContent-Length: %%d\r\n\r\n%%s";
                snprintf(fmtSmartRest, sizeof(fmtSmartRest), fmt, srHost, srAuthStr, srX_ID);
        } else {
                const char fmt[] = "POST %%s HTTP/1.0\r\nHost: %s\r\nAuthorization: Basic %s\r\nContent-Length: %%d\r\n\r\n%%s";
                snprintf(fmtSmartRest, sizeof(fmtSmartRest), fmt, srHost, srAuthStr);
        }
}

void setX_ID(const char* id)
{
        if (id) {
            srX_ID = id;
            setSmartRestFmt();
        }
}

void setDeviceID(long id)
{
        deviceID = id;
}

void setAuth(const char *tenant, const char *username, const char *password)
{
        if (tenant)
            setTenant(tenant);
        if (username)
            setUsername(username);
        if (password)
            setPassword(password);
        if (tenant || username || password) {
            char s[CREDENTIAL_LENGTH*2];
            snprintf(s, sizeof(s), "%s/%s", tenant, username);
            setAuthStr(s, password);
            setSmartRestFmt();
        }
}