#ifndef POLLTHREAD_H
#define POLLTHREAD_H
#include "SmartRestSocket.h"
#include "Operation.h"
#include "SmartRestConf.h"
#include "ControlParser.h"

class PollThread
{
public:
        PollThread(OperationPool& pool): sock(), parser(pool),
                thread(PollThread::threadWrapper, this) {
                strncpy(uri, "/devicecontrol/notifications", sizeof(uri));
        }
        virtual ~PollThread() {}
        bool handshake();
        bool subscribe();
        bool connect();
        void setChannel(long channel) { snprintf(chn, sizeof(chn), "/%ld", channel); }
        void threadFunc();
        static void threadWrapper(const void *p) { ((PollThread*)p)->threadFunc(); }
private:
        char chn[16];
        char uri[30];
        char bayeuxId[50];
        char buf[SMARTREST_SIZE];
        char buf2[SMARTREST_BODY_SIZE];
        SmartRestSocket sock;
        ControlParser parser;
        Thread thread;
};

#endif /* POLLTHREAD_H */
