#ifndef OPERATIONSTORE_H
#define OPERATIONSTORE_H
#include "rtos.h"
#define POOL_SIZE 32

enum OperationState {
        OPERATION_PENDING,
        OPERATION_EXECUTING,
        OPERATION_SUCCESSFUL,
        OPERATION_FAILED
};

struct Operation {
    long identifier;
    OperationState state;
};

typedef Mail<Operation, POOL_SIZE> OperationPool;

const char* strOperationState(OperationState state);
extern const char *strPending;
extern const char *strExecuting;
extern const char *strSuccessful;
extern const char *strFailed;

#endif
