#include <ctype.h>
#include "LCDDisplay.h"
#include "logging.h"

#define DEF "\033[39m"
#define GRE "\033[32m"
#define CYA "\033[36m"

void LCDDisplay::_setLine(char *dest, const char* src, size_t n)
{
        if (n == 0) {
                return ;
        } else if (src && src!=dest) {
                size_t j = 0;
                for (size_t i = 0; src[i] && j<n; ++i) {
                        if (isprint(src[i]))
                                dest[j++] = src[i];
                }
                dest[n-1] = '\0';
                if (j < n)
                    dest[j] = '\0';
        }
}

void LCDDisplay::clear()
{
        _setLine(firstLine, "", sizeof(firstLine));
        _setLine(secondLine, "", sizeof(secondLine));
        _setLine(thirdLine, "", sizeof(thirdLine));
        _lcd.cls();
}

void LCDDisplay::setFirstLine(const char* p)
{
        _setLine(firstLine, p, sizeof(firstLine));
        lcdPrint(firstLine, secondLine, thirdLine);
}

void LCDDisplay::setSecondLine(const char* p)
{
        _setLine(secondLine, p, sizeof(secondLine));
        lcdPrint(firstLine, secondLine, thirdLine);
}

void LCDDisplay::setThirdLine(const char* p)
{
        _setLine(thirdLine, p, sizeof(thirdLine));
        lcdPrint(firstLine, secondLine, thirdLine);
}

void LCDDisplay::setLines(const char *p1, const char *p2, const char *p3)
{
        _setLine(firstLine, p1, sizeof(firstLine));
        if (p2)
            _setLine(secondLine, p2, sizeof(secondLine));
        else
            _setLine(secondLine, "", sizeof(secondLine));

        if (p3)
            _setLine(thirdLine, p3, sizeof(thirdLine));
        else
            _setLine(thirdLine, "", sizeof(thirdLine));
        lcdPrint(firstLine, secondLine, thirdLine);
}

void LCDDisplay::lcdPrint(const char *l1, const char *l2, const char *l3)
{
    lcdLock.lock();
    _lcd.cls();
    _lcd.locate(0, 0);
    _lcd.printf("%s\n", l1);

    if (l2) {
        _lcd.printf("%s\n", l2);

        if (l3) {
            _lcd.printf("%s\n", l3);
        }
    }
    lcdLock.unlock();
}
