#ifndef MBEDAGENT_H
#define MBEDAGENT_H

#include "SmartRest.h"
#include "SmartRestTemplate.h"
#include "DeviceInfo.h"
#include "DeviceBootstrap.h"
#include "DeviceIntegration.h"

#include "Signal.h"
#include "Temperature.h"
#include "Location.h"
#include "Potentiometer.h"
#include "Acceleration.h"
#include "ConfigSync.h"

#include "OperationSupport.h"
#include "SmartRestConf.h"
#include "PollThread.h"
#include "ReportThread.h"
#include "LCDDisplay.h"

const size_t N = 6;

class MbedAgent
{
public:
    MbedAgent(DeviceInfo&);

    bool init();
    int run();
    void loop();

private:
    SmartRest client;
    SmartRestTemplate tpl;
    DeviceBootstrap _bootstrap;
    DeviceIntegration _integration;
    bool lcdThirdLineBlank;
    Signal signal;
    Temperature temp;
    Potentiometer poti;
    Location gps;
    Acceleration acc;
    char buf[SMARTREST_SIZE];
    char buf2[SMARTREST_BODY_SIZE];
    char status[DISPLAY_LEN];
    AbstractReporter *reporters[N];
    SmartRestSocket sock;
    OperationPool pool;
    OperationSupport _operationSupport;
};

#endif