#ifndef ABSTRACTREPORTER_H
#define ABSTRACTREPORTER_H
#include <stddef.h>

class AbstractReporter
{
public:
        virtual ~AbstractReporter() {}
        virtual bool init() = 0;

        /* A string representation of the actual report.
           \return identifying name of the class.
         */
        virtual const char* name() const = 0;

        /* Dump a SmartRest report to buf.
           \param buf  buffer for the report.
           \param maxLen  maximum length of buf.
           \param status  a short summary of the report.
                          Pass NULL if the status is not interested.
           \param num  maximum length of status.
           \return  number of characters written to buf, 0 means no report, -1 means error
         */
        virtual int read(char* buf, size_t maxLen,
                            char* status, size_t num) = 0;
};

#endif /* ABSTRACTREPORTER_H */