#ifndef CONTROLPARSER_H
#define CONTROLPARSER_H
#include "Operation.h"
#include "lex.h"

enum BayeuxAdvice{ BA_RETRY, BA_HANDSHAKE, BA_NONE };

class ControlParser
{
public:
        ControlParser(OperationPool& pool): opType(0), bayeuxAdvice(BA_RETRY),
        bayeuxTimeout(-1), bayeuxInterval(0), opool(pool) {}
        virtual ~ControlParser() {}
        BayeuxAdvice getBayeuxAdvice() const { return bayeuxAdvice; }
        int getBayeuxInterval() const { return bayeuxInterval; }
        int getBayeuxTimeout() const { return bayeuxTimeout; }
        void parse(const char*);
protected:
        typedef void (ControlParser::*PtrParseFunc)(Token&);
        void parseAdviceInterval(Token& tok);
        void parseAdvicePolicy(Token& tok);
        void parseAdviceTimeout(Token& tok);
        void parseBayeuxAdvice(Token& tok);
        void parseError(Token& tok);
        void parseGetOp(Token& tok);
        void parseGetOpOrBayeuxAdvice(Token& tok);
        void parseOpData(Token& tok);
        void parseOpId(Token& tok);
        void parseOpState(Token& tok);
        void parseOpType(Token& tok);
        void parseRecover(Token& tok);
        void parseRowNumber(Token& tok);
private:
        unsigned short opType;
        Operation op;
        BayeuxAdvice bayeuxAdvice;
        int bayeuxTimeout;
        int bayeuxInterval;
        PtrParseFunc ptrPF;
        OperationPool& opool;
};

#endif /* CONTROLPARSER_H */
