#ifndef SIGNAL_H
#define SIGNAL_H
#include "mbed.h"
#include "DeviceInfo.h"
#include "AbstractReporter.h"


class Signal: public AbstractReporter
{
public:
        Signal(DeviceInfo& d): deviceInfo(d), timer() {
                oldValues[0] = 0;
                oldValues[1] = 0;
                timer.start();
        }
        virtual ~Signal() {}
        virtual bool init() { return true; }
        virtual const char* name() const { return "dBm"; }
        virtual int read(char*, size_t, char*, size_t);
private:
        int oldValues[2];
        DeviceInfo& deviceInfo;
        Timer timer;
};

#endif /* SIGNAL_H */