#ifndef LOGGING_H
#define LOGGING_H

/* Enumeration of logging levels.
   Logging levels below have higher severity than the above levels.
 */
enum aLogLevel{
        A_DEBUG=1,
        A_INFO,
        A_WARNING,
        A_ERROR,
        A_CRITICAL,
        A_NONE     // No logging
};

/* All logging functions.
 * Function name indicates the corresponding logging level.
 * First argument is a format string, remaining arguments
 * must correspond to the given format, like in printf.
 */
int aDebug(const char *fmt, ...);
int aInfo(const char *fmt, ...);
int aWarning(const char *fmt, ...);
int aError(const char *fmt, ...);
int aCritical(const char *fmt, ...);

aLogLevel getLevel();
void setLevel(aLogLevel lvl);
void higherOneLevel();  // Set log level one severity higher (terser), does nothing when already highest
void lowerOneLevel();   // Set log level one severity lower (chattier), does nothing when already lowerest
#endif /* LOGGING_H */
