#include <cstdio>
#include <cstdarg>
#include "logging.h"
using namespace std;


aLogLevel _level = A_INFO;      // Default log level is INFO.

int _log(aLogLevel lvl, const char *fmt, va_list& vlist)
{
        if (_level <= lvl) {
                int n = 0;
                switch (lvl)
                {
                case A_DEBUG:    n += printf("[DEBUG] ");    break;
                case A_INFO:     n += printf("[INFO] ");     break;
                case A_WARNING:  n += printf("[WARN] ");     break;
                case A_ERROR:    n += printf("[ERROR] ");    break;
                case A_CRITICAL: n += printf("[CRITICAL] "); break;
                default:         n += printf("[UNKNOWN] ");  break;
                }
                return n+vprintf(fmt, vlist);
        } else {
                return 0;
        }
}

int aDebug(const char *fmt, ...)
{
        va_list vlist;
        va_start(vlist, fmt);
        int n = _log(A_DEBUG, fmt, vlist);
        va_end(vlist);
        return n;
}

int aCritical(const char *fmt, ...)
{
        va_list vlist;
        va_start(vlist, fmt);
        int n = _log(A_CRITICAL, fmt, vlist);
        va_end(vlist);
        return n;
}

int aError(const char *fmt, ...)
{
        va_list vlist;
        va_start(vlist, fmt);
        int n = _log(A_ERROR, fmt, vlist);
        va_end(vlist);
        return n;
}

int aInfo(const char *fmt, ...)
{
        va_list vlist;
        va_start(vlist, fmt);
        int n = _log(A_INFO, fmt, vlist);
        va_end(vlist);
        return n;
}

int aWarning(const char *fmt, ...)
{
        va_list vlist;
        va_start(vlist, fmt);
        int n = _log(A_WARNING, fmt, vlist);
        va_end(vlist);
        return n;
}

aLogLevel getLevel()
{
        return _level;
}

void setLevel(aLogLevel lvl)
{
        _level = lvl;
}

void higherOneLevel()
{
    switch (_level)
    {
    case A_DEBUG:    _level = A_INFO;     break;
    case A_INFO:     _level = A_WARNING;  break;
    case A_WARNING:  _level = A_ERROR;    break;
    case A_ERROR:    _level = A_CRITICAL; break;
    case A_CRITICAL: _level = A_NONE;     break;
    }
}

void lowerOneLevel()
{
    switch (_level)
    {
    case A_INFO:     _level = A_DEBUG;    break;
    case A_WARNING:  _level = A_INFO;     break;
    case A_ERROR:    _level = A_WARNING;  break;
    case A_CRITICAL: _level = A_ERROR;    break;
    case A_NONE:     _level = A_CRITICAL; break;
    }
}