/*
 * MbedDataSource.h
 *
 * Created on: Feb 1, 2013
 * * Authors: Vincent Wochnik <v.wochnik@gmail.com>
 *
 * Copyright (c) 2013 Cumulocity GmbH
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifndef MBEDDATASOURCE_H
#define MBEDDATASOURCE_H

#include <stddef.h>
#include "AbstractDataSource.h"
#include "TCPSocketConnection.h"

#define MBED_SOURCE_BUFFER_SIZE 600

class MbedClient;

class MbedDataSource : public AbstractDataSource
{
public:
    MbedDataSource(TCPSocketConnection& sock);
    virtual ~MbedDataSource();

    virtual char read();
    virtual uint8_t status();

protected:
    void setTimeout(size_t);
    bool receive();
    void reset();

private:
    TCPSocketConnection& _sock;
    char _buf[MBED_SOURCE_BUFFER_SIZE];
    size_t _len, _offset, _timeout;
    bool _isTimedOut;

friend class MbedClient;
};

#endif
