/*
 * FloatValue.h
 *
 * Created on: Nov 1, 2013
 * * Authors: Vincent Wochnik <v.wochnik@gmail.com>
 *
 * Copyright (c) 2013 Cumulocity GmbH
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifndef FLOATVALUE_H
#define FLOATVALUE_H

#include "config.h"
#include <stdint.h>
#include "Value.h"

#define SMARTREST_FLOATVALUE_DETECTPREC 255

/**
 * A floating-point value.
 * 
 * Example:
 * @code
 * // decleration                       // serialized form
 * FloatValue val1(3.1415, 2);          // 3.14
 * FloatValue val2(3.1234, 0);          // 3
 * FloatValue val3(3.95, 0);            // 4
 * FloatValue val4(0.55, 1, false);     // .5
 * FloatValue val4(0.55, 2, true);      // 0.55
 * @encode
 */
class FloatValue : public Value
{
	public:
		/**
		 * Creates a new instance of a floating-point value.
		 * @param number the floating-point number
		 * @param digits precision in number of digits
		 * @param zflag whether to write a zero before the floating point
		 */
		FloatValue(double, uint8_t = SMARTREST_FLOATVALUE_DETECTPREC, bool = true);

		virtual uint8_t valueType() const;
		virtual long integerValue() const;
		virtual double floatValue() const;
		virtual const char * characterValue() const;

		virtual size_t write(AbstractDataSink&) const;
		virtual size_t length() const;
		virtual Value* copy() const;

	protected:
		uint8_t detectPrecision(double);

	private:
		double _number;
		bool _negative;
		uint8_t _digits;
		bool _zflag;
};

#endif
