/*
 * MbedDataSink.cpp
 *
 * Created on: Feb 1, 2013
 * * Authors: Vincent Wochnik <v.wochnik@gmail.com>
 *
 * Copyright (c) 2013 Cumulocity GmbH
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#include <stdlib.h>
#include <string.h>
#include "mbed.h"
#include "MbedDataSink.h"
#include "MbedClient.h"
#include "logging.h"


MbedDataSink::MbedDataSink(TCPSocketConnection& sock) : _sock(sock), _len(0)
{
}

MbedDataSink::~MbedDataSink()
{
}

size_t MbedDataSink::write(char c)
{
    while (MBED_SINK_BUFFER_SIZE - _len < 1) {
        if (!send())
            return 0;
    }
    
    _buf[_len++] = c;
    return 1;
}

size_t MbedDataSink::write(void *buf, size_t length)
{
    size_t sent = 0, len;
    
    while (sent < length) {
        while (MBED_SINK_BUFFER_SIZE - _len < 1) {
            if (!send())
                return 0;
        }
        
        if (MBED_SINK_BUFFER_SIZE - _len >= length-sent)
            len = length-sent;
        else
            len = MBED_SINK_BUFFER_SIZE - _len;
        
        memcpy(_buf+_len, (char*)buf+sent, len);
        _len += len;
        sent += len;
    }
    return length;
}

size_t MbedDataSink::write(const char *str)
{
    return write((void*)str, strlen(str));
}

size_t MbedDataSink::write(unsigned long number)
{
    char str[24];
    snprintf(str, 24, "%lu", number);
    return write(str);
}

bool MbedDataSink::flush()
{
    while (_len > 0) {
        if (!send())
            return false;
    }
    
    return true;
}

bool MbedDataSink::send()
{
    int ret;
    
    if (!_sock.is_connected())
        return false;

    _sock.set_blocking(true);
    ret = _sock.send(_buf, _len);
    
    //TODO: fix bug in u-blox so no longer wait is needed
//    wait(0.5);
    
    if (ret < 0){
        aError("Sink: Send failed.\n");
        return false;
    }
    
    // move rest of buffer
    if ((ret > 0) && (ret < _len))
        memmove(_buf, _buf+ret, _len-ret);
    
    _len -= ret;
    return true;
}

void MbedDataSink::reset()
{
    _len = 0;
}
