/*
 * IntegerValue.h
 *
 * Created on: Nov 1, 2013
 * * Authors: Vincent Wochnik <v.wochnik@gmail.com>
 *
 * Copyright (c) 2013 Cumulocity GmbH
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifndef NUMBERVALUE_H
#define NUMBERVALUE_H

#include "config.h"
#include "Value.h"

/**
 * Represents an integer value.
 * 
 * Example:
 * @code
 * IntegerValue val(100);
 * @encode
 */
class IntegerValue : public Value
{
	public:
		IntegerValue(long);

		virtual uint8_t valueType() const;
		virtual long integerValue() const;
		virtual double floatValue() const;
		virtual const char * characterValue() const;

		virtual size_t write(AbstractDataSink&) const;
		virtual size_t length() const;
		virtual Value* copy() const;

	private:
		unsigned long _number;
		bool _negative;
};

#endif
