#ifndef SUPPORTFUNCS_H
#define SUPPORTFUNCS_H

#include <cmath>
#include "globals.h"
#include "tvmet/Matrix.h"

//Constrains agles to +/- pi
inline float constrainAngle(float x){
    x = fmod(x + PI, 2*PI);
    if (x < 0)
        x += 2*PI;
    return x - PI;
}

template <typename T>
tvmet::Matrix <T, 2, 2> Rotmatrix(T theta) {
     tvmet::Matrix <T, 2, 2> outmatrix;
     outmatrix = cos(theta), -sin(theta),
                 sin(theta), cos(theta);
     return outmatrix;
}

#endif //SUPPORTFUNCS_H