#ifndef KALMAN_H
#define KALMAN_H

#include "globals.h"
#include "rtos.h"

namespace Kalman
{

//Accessor function to get the state as one consistent struct
State getState();

//Main loops (to be attached as a thread in main)
void predictloop(void const*);
void updateloop(void const*);

void start_predict_ticker(Thread* predict_thread_ptr_in);

enum measurement_t {SONAR0 = 0, SONAR1, SONAR2, IR0, IR1, IR2};
const measurement_t maxmeasure = IR2;

//Call this to run an update
void runupdate(measurement_t type, float value, float variance);

extern float RawReadings[maxmeasure+1];
extern float IRphaseOffset;

extern bool Kalman_inited;

//Initialises the kalman filter
void KalmanInit();

}

#endif //KALMAN_H