
#include "rtos.h"
#include "mbed.h"
#include "Printing.h"

Timer SystemTime;

Ticker CPUIdleMeasureTicker;
volatile unsigned int nopctr = 0;
const float s_per_nopcycle = 1.0f/16000000.0f;

float CpuUsage = 0;

void nopwait(int ms){
while(ms--)
    for (volatile int i = 0; i < 24000; i++);
}

void PostAndResetCPUIdle(){
    static int oldnopctr = 0;
    int deltanop = nopctr - oldnopctr;
    oldnopctr = nopctr;
    CpuUsage = 1.0f - (s_per_nopcycle * deltanop);
    Printing::updateval(10,CpuUsage);
}

void measureCPUidle (void const*){
    
    osThreadSetPriority (osThreadGetId(), osPriorityIdle);
    Printing::registerID(10, 1);
    
    CPUIdleMeasureTicker.attach(PostAndResetCPUIdle, 1);
    
    while(1)
        nopctr++;
}
