#ifndef EUROBOT_PROCESSES_MOTION_MOTION_H_
#define EUROBOT_PROCESSES_MOTION_MOTION_H_

#include "globals.h"
#include "rtos.h"
#include "math.h"
#include "Kalman.h"
#include "MotorControl.h"
#include "supportfuncs.h"

namespace motion
{

void motionlayer(void const *dummy);

// can encapsulate mutex fully in motion with something like: bool set_new_wp_if_current_reached()
void setNewWaypoint(Waypoint *new_wp);
void setWaypointReached();
void clearWaypointReached();
bool checkWaypointStatus();

extern Mutex waypoint_flag_mutex;

}

#endif //EUROBOT_PROCESSES_MOTION_MOTION_H_