
// Eurobot13 WhiteArm.h

#include "mbed.h"
#include "Servo.h"

class Arm : public Servo
{
private:
    bool updirn;

public:
    Arm ( PinName yellowPWM
        , bool upflip = false
        , float range = 0.0005, float degrees = 45.0
        ) 
        : Servo(yellowPWM) 
        {
        calibrate(range, degrees);
        updirn = upflip;
    }

    void operator()(float in) {
        write(in);
    }

    void clockwise() { // full lock clockwise
        write(updirn?1:0);
    }

    void anticlockwise() { // full lock anticlockwise
        write(updirn?0:1);
    }
    
    virtual void halt() { // servo applies no force
        //DigitalOut myled(LED3);
        //myled = 1;
        _pwm = 0;
    }
};


/*
class Servo{
    private:
    PwmOut PWM;

    public:
    Servo(PinName pin1) : PWM(pin1){
    }

    void operator()(float in){
        PWM = in;
    }

    void clockwise() { // full lock clockwise
        PWM = .135;
    }

    void anticlockwise() { // full lock anticlockwise
        PWM = .025;
    }

    void relax() { // servo applies no force
        PWM = 0;
    }

};
*/