#include "mbed.h"
#include "PwmIn.h"
#include "globals.h"
#include "rtos.h"

#define PWM_INVERT

DigitalOut led1(LED1);
DigitalOut led2(LED2);
Serial pc(USBTX, USBRX); // tx, rx

PwmIn My_PWM(p30);
float my_dutycycle;
Semaphore serial_sema(1);

void PWM_Callback(float dutycycle) {
    led1 = !led1;
    my_dutycycle = dutycycle;
    serial_sema.release();
    
}


void serial_thread(void const *argument) {
    while (true) {
        serial_sema.wait();
        printf("dutycycle: %0.4f \n\r", my_dutycycle);
    }
}
 
int main() {
    pc.baud(19200);
    pc.printf("Hello from mbed\n");    
    
    My_PWM.callbackfunc = PWM_Callback;

    Thread thread(serial_thread);
    
    while (true) {
        Thread::wait(osWaitForever);
    }
}
