#ifndef MBED_IR_TURRET_H
#define MBED_IR_TURRET_H



#include "mbed.h"
#include "PwmIn.h"
#include "globals.h"
#include "geometryfuncs.h"

// Stepper motor defines go here, p30 is reserved for the hardware counter
#define STEPPER_PERIOD 0.0001   //Stepper motor period in seconds, 50% duty cycle
#define STEPPER_DIV   3200    // number of steps per cycle = default * microstep
#define STEP_ANGLE   ((float)(2*PI) / STEPPER_DIV)    // step angle of stepper
#define IR_TIMEOUT_STEP 45 //about 5 degrees
#define IR_TIMEOUT (STEPPER_PERIOD*IR_TIMEOUT_STEP)


// IR Sensor defines go here
#define PWM_INVERT // inverts the PWM for the IR sensor pwm input
#define PULSEPERIOD_US 1500
#define PULSEPERIOD ((float)1500/1000000)
#define IR0_PULSEWIDTH 1000
#define IR1_PULSEWIDTH 750
#define IR2_PULSEWIDTH 500
#define PULSEWIDTH_TOLERANCE 125
#define STEPS_PER_PULSEPERIOD (PULSEPERIOD/STEPPER_PERIOD)

/* SAMPLE IMPLEMENTATION!
IR_TURRET my_ir_turret(stepper_pin,ir_pin);


void callbinmain(int num, float dist) {
    //Here is where you deal with your brand new reading ;D
}

int main() {
    pc.printf("Hello World of RobotSonar!\r\n");
    my_srf.callbackfunc = callbinmain;
    
    while (1);
}

 */
 
class DummyCT;
 
class IR_TURRET {
public:

    IR_TURRET(
    PinName step_pin, 
    PinName ir_pin);

    
    /** A assigns a callback function when a new reading is available **/
    void (*callbackfunc)(int beaconnum, float angle, float variance);
    DummyCT* callbackobj;
    void (DummyCT::*mcallbackfunc)(int beaconnum, float angle, float variance);
    
    
    
private :
    PwmOut _step;
    PwmIn _ir;
    Timeout _ir_timeout;
    void _ir_timeout_isr (void);
    void _ir_isr (float pulsewidth);
    
    int step_count_old;
    int IR_counter;
    int IR_step_counter;
    float pulsewidth_max;
    float _angle[3];
    float _variance[3];
    
    
    
};

#endif
