#include "mbed.h"
#include "EthernetInterface.h"
#include "SNTPClient.h"


int main() {
//    EthernetInterface eth;
// change for W5500 interface.
#if defined(TARGET_LPC1114)
    SPI spi(dp2, dp1, dp6); // mosi, miso, sclk
    EthernetInterface eth(&spi, dp25, dp26); // spi, cs, reset

#elif defined(TARGET_LPC1768)
    SPI spi(p11, p12, p13); // mosi, miso, sclk
    EthernetInterface eth(&spi, p14, p15); // spi, cs, reset

#elif defined(TARGET_LPC11U68)
    SPI spi(P0_9, P0_8, P1_29); // mosi, miso, sclk
    EthernetInterface eth(&spi, P0_2, P1_28);//, nRESET(p9); // reset pin is dummy, don't affect any pin of WIZ550io

#else
    #warning "The Device is Undefined"
#endif

    spi.format(8,0); // 8bit, mode 0
    spi.frequency(7000000); // 7MHz
    wait(1); // 1 second for stable state

    eth.init(); //Use DHCP
    //eth.init("192.168.11.111", "255.255.255.0", "192.168.11.1"); //Use Static IP
    eth.connect();
    printf("IP Address is %s\n\r", eth.getIPAddress());

    SNTPClient sntp("time.nist.gov", 40);   // timezone: Korea, Republic of
    sntp.connect();

    datetime time;
#if 0   // execute once..
    while (sntp.getTime(&time) != true) {
        ;
    }
    printf("%d-%d-%d, %d:%d:%d\r\n", time.yy, time.mo, time.dd, time.hh, time.mm, time.ss);
#else   // infinete loop..
    while (1) {
        if(sntp.getTime(&time) == true) {
            printf("%d-%d-%d, %d:%d:%d\r\n", time.yy, time.mo, time.dd, time.hh, time.mm, time.ss);
            wait(1.0);
        }
        else {
            printf("failed receive..\r\n");
        }
    }
#endif
}