#include "xenonym_logging.h"

namespace xenonym { namespace logging {

RealLogger RealLogger::logger;
NullLogger NullLogger::logger;

RealLogger::RealLogger()
 : m_comms( USBTX, USBRX ), m_radix(10)
{
    m_comms.printf("\nLogging ENABLED");
}

RealLogger & RealLogger::operator<< ( unsigned i )
{
    switch( m_radix )
    {
    default:
        m_comms.printf( "(bad radix:%d) dec:", m_radix ) ;
    case 10:
        m_comms.printf( "%u", i ) ;
        break;
    case 16:
        m_comms.printf( "%x", i ) ;
        break;
    }
    return *this;
}

RealLogger & RealLogger::operator<< ( int i )
{
    switch( m_radix )
    {
    default:
        m_comms.printf( "(bad radix:%d) dec:", m_radix ) ;
    case 10:
        m_comms.printf( "%d", i ) ;
        break;
    case 16:
        m_comms.printf( "%x", i ) ;
        break;
    }
    return *this;
}

RealLogger & RealLogger::operator<< ( long long i )
{
    switch( m_radix )
    {
    default:
        m_comms.printf( "(bad radix:%d) dec:", m_radix ) ;
    case 10:
        m_comms.printf( "%lld", i ) ;
        break;
    case 16:
        m_comms.printf( "%llx", i ) ;
        break;
    }
    return *this;
}

RealLogger & RealLogger::operator<< ( unsigned long long int i )
{
    switch( m_radix )
    {
    default:
        m_comms.printf( "(bad radix:%d) dec:", m_radix ) ;
    case 10:
        m_comms.printf( "%llu", i ) ;
        break;
    case 16:
        m_comms.printf( "%llx", i ) ;
        break;
    }
    return *this;
}

RealLogger & RealLogger::operator<< ( char i )
{
    m_comms.printf( "%c", i ) ;
    return *this;
}

RealLogger & RealLogger::operator<< ( char const * str )
{
    m_comms.printf( "%s", str ) ;
    return *this;
}

class RealLogManipulator : public LogManipulator
{
public:
    virtual void log ( unsigned i )           { RealLogger::logger << i; }
    virtual void log ( int i )                { RealLogger::logger << i; }
    virtual void log ( long long i )          { RealLogger::logger << i; }
    virtual void log ( unsigned long long i ) { RealLogger::logger << i; }
    virtual void log ( char c )               { RealLogger::logger << c; }
    virtual void log ( char const * str )     { RealLogger::logger << str; }
    virtual void set_radix ( int i ) { RealLogger::logger.m_radix = i; }
    virtual void set_indent ( int i ) { RealLogger::logger.m_indent = i; }
    virtual int  get_indent ()        { return RealLogger::logger.m_indent; }
};

RealLogger & RealLogger::operator<< ( manipFunc manipulator )
{
    RealLogManipulator r;
    manipulator( r );
    return *this;
}

void eol( LogManipulator & lm ) { lm.log( "\r\n" ); for( int i = 0,  e = lm.get_indent(); i < e ; ++i ) { lm.log( (i%4)==2 ? '|' : ' ' ); } }
void hex( LogManipulator & lm ) { lm.set_radix( 16 ); }
void dec( LogManipulator & lm ) { lm.set_radix( 10 ); }
void indent( LogManipulator & lm )  { int i = lm.get_indent(); if ( i < 40 ) lm.set_indent( i + 2 ); }
void outdent( LogManipulator & lm ) { int i = lm.get_indent(); if ( i > 1  ) lm.set_indent( i - 2 ); }

Locn::Locn( char const * const file, int line ) 
: m_file(file), m_line( line ) 
{
}

Locn::~Locn()
{
}
        
Scope::Scope( char const * const file, int line ) 
: Locn( file, line ) 
{
    LOG << "entering scope " << file << ":" << dec << line << indent;
}
Scope::~Scope()
{
    LOGGER << outdent << eol << "leaving scope " << m_file << ":" << dec << m_line;
}

Func::Func( 
    char const * const name, char const * const file, int line 
) : Locn( file, line ), m_name( name )
{
    LOG << "entering " << name << " " << file << ":" << dec << line << indent;
}

Func::~Func() 
{
    LOGGER << outdent << eol << "leaving " << m_name << " " << m_file << ":" << dec << m_line;
}

} //    namespace logging
} //    namespace xenonym
