#include "mbed.h"
#include "keypad.h"
#include "cryst_lcd.h"
#include "FPScanner.h"

typedef struct{
    int user_id;
    int hash;
} HASH_RECORD;

int hashcode(const char *data, int size);
void read_mag_card(Serial *device, char *dest, int *size);
bool fp_enroll(FPScanner *fp);
bool fp_auth(FPScanner *fp);
bool face_enroll(char *user_id, Serial *android);
bool face_auth(char *user_id, Serial *android);
bool speech_auth(char *user_id, Serial *android);
bool speech_enroll(char *user_id, Serial *android);
bool voice_enroll(char *user_id, Serial *android);
bool voice_auth(char *user_id, Serial *android);
void buzzer(PwmOut *speaker, int seconds);
void display_msg(Cryst_LCD *lcd, char *text);
bool read_pin(char *buffer, int length, Cryst_LCD* lcd, Keypad<4, 3>* pad);
void greeting(Cryst_LCD *lcd);
bool prompt(const char* msg, Cryst_LCD *lcd, Keypad<4, 3>* pad);

// to implement
bool is_valid_user(char *user_id);
bool write_hash_to_file(char *user_id, int hash);
bool read_hash_from_file(char *user_id, int *hash);
bool fp_clearAll(FPScanner *fp);
char clear_serial_buffer(Serial *dev);