#include <iostream>

#include "mbed.h"
#include "Map.hpp"
#include "TCS3200.h"

DigitalOut red(PA_9);
DigitalOut green(PC_7);
DigitalOut blue(PB_6);

Serial pc(USBTX, USBRX);

/**
Nucleo - TCS3200 interfacing pins 
s0 (PA_8);    // pin D7
s1 (PB_10);   // pin D6
s2 (PB_4);    // pin D5
s3 (PB_5);    // pin D4
*/

int main() {
  
    
    int red_pw, green_pw, blue_pw;
    int input; 
    int counter = 0;
    
    // Pulse width calibration values
    int red_min    = 31;
    int red_max    = 301;
    int green_min  = 37;
    int green_max  = 389;
    int blue_min   = 29;
    int blue_max   = 310;
    int R, G, B;
    
    TCS3200 pw(PA_8, PB_10, PB_4, PB_5, PA_5);
    
    Map r_map(red_min, red_max, 255, 0);    
    Map g_map(green_min, green_max, 255, 0);
    Map b_map(blue_min, blue_max, 255, 0);
    
    
    pw.SetMode(TCS3200::SCALE_100);
   
         pc.printf("Please type a value:");
         pc.scanf("%i", &input);  // & to pass a pointer to input
         pc.printf("\nThe input value is: %i\n", input);
         pc.printf("Reading in 3...");
         wait(1.5);
         pc.printf("2...");
         wait(1.5);
         pc.printf("1\n");
    while(counter < input){
         
         
        red_pw     = pw.ReadRed();
        green_pw   = pw.ReadGreen();
        blue_pw    = pw.ReadBlue();
      
        //printf("Red:    %d        Green: %d         Blue: %d  \n\r",  red_pw, green_pw, blue_pw);
       
        
        R = r_map.Calculate(red_pw);
        G = g_map.Calculate(green_pw);
        B = b_map.Calculate(blue_pw);
        
        if(R < 0)
        R = 0;      
        else if(R > 255)
        R = 255;

            
        if(G < 0)
        G = 0;       
        else if(G > 255)
        G = 255;

        
        if(B < 0)
        B = 0;   
        else if(B > 255)
        B = 255;
        
        printf("Red:   %i     Green:   %i     Blue:   %i \n", R, G, B);
        
        wait(.5);
        
        counter++;
        }  
        
}