#include "mbed.h"
#include "UDPSocket.h"
#include "Endpoint.h"
#include "EthernetInterface.h"
 
AnalogIn analog_value(A0);

#define ETH0_RST    D5
#define ETH0_CS     D10
#define ETH0_MOSI   D11
#define ETH0_MISO   D12
#define ETH0_SCK    D13

Endpoint remote;
EthernetInterface eth0(ETH0_MOSI, ETH0_MISO, ETH0_SCK, ETH0_CS, ETH0_RST);
UDPSocket udp0;
 
DigitalOut led(LED1);

int main() {
    remote.set_address("192.168.91.1", 31415);
    eth0.connect();
    udp0.set_blocking(false);
    
    float meas;
    
    printf("\nAnalogIn example\n");
    
    while(1) {
        meas = analog_value.read(); // Converts and read the analog input value (value from 0.0 to 1.0)
        meas = meas * 3300; // Change the value to be in the 0 to 3300 range
        //printf("measure = %.0f mV\n", meas);
        if (meas > 2000) { // If the value is greater than 2V then switch the LED on
          led = 1;
        }
        else {
          led = 0;
        }
        udp0.sendTo(remote, (char *)&meas, sizeof(meas));
        //wait(0.2); // 200 ms
    }
}
