#include "mbed.h"

//simple benchmark, see main for results  

DigitalOut led(LED1);


AnalogIn   Ain(A0);       


Serial pc(USBTX, USBRX); // tx, rx

Timer Tim, Timc;
int dt;
float dtavg;


#define Nsamp 2000
unsigned short samples[Nsamp];   //analogin sample table 

volatile float x,s;  //volatile to prevent compiler from optimizing loops
volatile float y;

volatile double dx, ds;
volatile double dy;  

volatile long ix,iy,is;

//************************
inline void test_acq()
{
    int N=Nsamp;
      register int i;
         Tim.reset(); Tim.start();
      for(i=0; i<N; i++) {
        samples[i] = Ain.read_u16();
    }
    Tim.stop();
    dt=Tim.read_us(); 
    dtavg=dt/(float) Nsamp;
    pc.printf(" input of %d values: total %d, avg: %f \r\n",N, dt, dtavg);
    
}



inline void testmullong()
{
int N=100000;

x=Timc.read_ms(); y=Timc.read_ms();
Tim.reset(); Tim.start();
Timc.start();

for(int i=0; i<N; i++) {
       is=is+ix*iy;
    }
    Tim.stop();
    dt=Tim.read_us(); 
    dtavg=dt/(float)N;
    pc.printf(" add-mult of %d longs: total %d, avg: %f \r\n", N, dt, dtavg);
   
}


inline void testmulfloat()
{
int N=100000;

x=Timc; y=Timc;
Tim.reset(); Tim.start();


for(int i=0; i<N; i++) {
       s=s+x*y;
    }
    Tim.stop();
    dt=Tim.read_us(); 
    dtavg=dt/(float)N;
    pc.printf(" add-mult of %d floats: total %d, avg: %f \r\n", N, dt, dtavg);
   
}


inline void testdivfloat()
{
int N=100000;

x=Timc; y=Timc;
Tim.reset(); Tim.start();


for(int i=0; i<N; i++) {
       s=s+x/y;
    }
    Tim.stop();
    dt=Tim.read_us(); 
    dtavg=dt/(float)N;
    pc.printf(" add-div of %d floats: total %d, avg: %f \r\n", N, dt, dtavg);
   
}


inline void testsin()
{
int N=10000;

x=Timc; 
Tim.reset(); Tim.start();


for(int i=0; i<N; i++) {
       s=s+sin(x);
    }
    Tim.stop();
    dt=Tim.read_us(); 
    dtavg=dt/(float)N;
    pc.printf(" add-sin of %d floats: total %d, avg: %f \r\n", N, dt, dtavg);
   
}


inline void testmuldouble()
{
int N=100000;

dx=Timc; dy=Timc;
Tim.reset(); Tim.start();

for(int i=0; i<N; i++) {
       ds=ds+dx*dy;
    }
    Tim.stop();
    dt=Tim.read_us(); 
    dtavg=dt/(float)N;
    pc.printf(" add-mult of %d doubles: total %d, avg: %f \r\n", N, dt, dtavg);
   
}


inline void testdivdouble()
{
int N=100000;

dx=Timc; dy=Timc;
Tim.reset(); Tim.start();

for(int i=0; i<N; i++) {
       ds=ds+dx/dy;
    }
    Tim.stop();
    dt=Tim.read_us(); 
    dtavg=dt/(float)N;
    pc.printf("add-div of %d doubles: total %d, avg: %f \r\n", N, dt, dtavg);
   
}



//**********************

int main() {


  //pc.baud(115200);  //set terminal to 115200 baud
  
    pc.printf("start\n");
    
    Tim.reset();
    led=0;

    while(1) 
    {
        led = 1-led; 
           pc.printf("\n\n ");
      test_acq();  //KL25z: 32.6us per loop;  F303RE: 8.1us per loop
      testmullong();  //KL25z: 0.25  F303RE: 0.132
      testmulfloat();  //KL25z: 2.61  F303RE: 0.187
      testdivfloat(); // KL25z: 3.68     F303RE: 0.35   
      testsin();      //KL25z: 13.6      F303RE: 1.57
      testmuldouble();  //KL25z: 8.44  F303RE: 6.84
      testdivdouble();  //KL25z: 13.7 F303RE: 17.5
      
      wait(1); 
    }
    
}
