#include "mbed.h"
#include "math.h"
#include <stdio.h>
#include "funcs.h"


Serial pc1(SERIAL_TX, SERIAL_RX);

//Funcao para criar um mapa simples com um quadrado no meio
void read_map1(int Map_Matrix[80][80]){
    for(int i = 0; i < 80; i++){
        for(int j = 0; j < 80; j++){
            if(i == 0 || j==0 || i==79 || j==79){
                Map_Matrix[i][j] = 1;  
            }     
            else{
                Map_Matrix[i][j] = 0;
                if(i >= 10 && j>=10 && i<=69 && j<=69){
                    Map_Matrix[i][j] = 1;
                }
            }              
        }
    } 
}

//Funcao para criar um mapa mias pequeno com um quadrado no meio
void read_map2(int Map_Matrix[80][80]){
    for(int i = 0; i < 80; i++){
        for(int j = 0; j < 80; j++){
            Map_Matrix[i][j] = 0;  
            
            if((i >= 30 || j >= 30) || (i >= 10 && j >= 10 && i <= 15 && j <= 15) || (i >= 17 && j >= 17 && i <= 23  && j <= 23)){
                Map_Matrix[i][j] = 1;
            } 
        }
    } 
}

//Funcao para obter a matriz das redondezas do robo 
void get_Surroundings_Matrix(int Surroundings_Matrix[15][15], double actual_position_x, double actual_position_y, int Map_Matrix[80][80]){
    double map_position_x1 = floor(actual_position_x/50);
    double map_position_y1 = floor(actual_position_y/50);
    
    int map_position_x = (int) map_position_x1;
    int map_position_y = (int) map_position_y1;
    
    int i = 0;
    int j = 0;
    for(int x = map_position_x-7; x < map_position_x+8; x++){
        for(int y = map_position_y-7; y < map_position_y+8; y++){
            if(x < 0 || x > 79 || y < 0 || y > 79){
                Surroundings_Matrix[i][j] = 1;
            }    
            else{
                Surroundings_Matrix[i][j] = Map_Matrix[x][y];
            }
            j = j + 1;
        }
        i = i + 1;
        j = 0;
    }
    
    for(int x = 0; x < 15; x++){ 
        for(int y = 0; y < 15; y++){
            pc1.printf("%d,", Surroundings_Matrix[x][y]);  
        }
        pc1.printf("\n"); 
    }
}    

//Funcao para obter o angulo de orientacao seguinte
double get_orientation_angle(double actual_position_x, double actual_position_y, double end_position_x, double end_position_y, int Surroundings_Matrix[15][15]){
    double Force_vector_x;
    double Force_vector_y;
    double distance;
    double orientation_angle;
    
    distance = sqrt((double)(end_position_x-actual_position_x)*(end_position_x-actual_position_x)+(end_position_y-actual_position_y)*(end_position_y-actual_position_y));
    
    //Vetor forca atrativa
    Force_vector_x = 2*(end_position_x - actual_position_x)/(distance);
    Force_vector_y = 2*(end_position_y - actual_position_y)/(distance);
    pc1.printf("x = %f, y = %f\n", Force_vector_x, Force_vector_y);
    
    //Subtracao das forcas repulsivas
    for(int x = 0; x < 15; x++){
        for(int y = 0; y < 15; y++){
            if(!(x == 7 && y == 7)){
                distance = sqrt((double)(x-7)*(x-7) + (y-7)*(y-7));
                Force_vector_x = Force_vector_x - (Surroundings_Matrix[x][y]/(distance*distance))*((x-7)/distance);
                Force_vector_y = Force_vector_y - (Surroundings_Matrix[x][y]/(distance*distance))*((y-7)/distance);
             }
        }
    }

    orientation_angle = atan2(Force_vector_y,Force_vector_x);
    return(orientation_angle);
}
