#include "mbed.h"
#include "Robot.h"
#include "funcs.h"

static const double pi = 3.14159265358;
DigitalIn Button(USER_BUTTON);
Serial pc(SERIAL_TX, SERIAL_RX);


int main() {
    //Espera que o botao seja premido
    while (Button == 1) {}
    wait(1);
    
    //Matrizes de mapeamento
    int Map_Matrix[80][80];             //Matriz do mapa
    int Surroundings_Matrix[15][15];    //Matriz das redondezas
    
    //Ganhos
    double k = 8;                       //Ganho angular
    
    //Variaveis de posicao
    double x = 300;                     //x inicial
    double y = 300;                     //y inicial
    double phi = 0.01;                  //phi inicial
    double end_position_x = 1400;       //x final
    double end_position_y = 1400;       //y final
    double next_phi;                    //phi seguinte
    
    //Variaveis de estimacao de posicao
    double var_l;                       //contagens do encoder esquerdas
    double var_r;                       //contagens do encoder direitas
    double var_d;                       //variacao linear entre iteracoes    
    double var_phi;                     //variacao angular entre iteracoes
    double L = 150;                     //distancia entre rodas 
    double r = 35;                      //raio da roda
    
    //Variaveis de comando as rodas
    double w;                           //velociade angular do robo
    double w_left;                      //velocidade da roda esquerda    
    double w_right;                     //velocidade da roda direita 
    double v = 2400;                    //velocidade linear do robo
    /*
    double erro = 0;
    double e = 0;
    double d = 20;          //5 contimetros para ir andando para a frente
    float kv = 3;
    float ki = 0.1;    // nao conseguimos obter ganhos adquados para o controlo pretendido
                        // pelo que considermos a velocidade constante ao longo do nosso programa
                        
    */
    
    //Funcao de obtencao do Mapa    
    read_map2(Map_Matrix);              
    
    while(sqrt((double)pow(x-end_position_x,2) + pow(y-end_position_y,2)) > 100){
        //Obter as contagens dos encoders
        getCountsAndReset();

        //Estimacao de pose
        var_l = (2*pi*r*countsLeft/1440);
        var_r = (2*pi*r*countsRight/1440);
        var_d = (var_l+var_r)/2;
        var_phi= (var_r-var_l)/L;

        if(var_phi == 0){
            x = x + var_d*cos(phi);
            y = y + var_d*sin(phi);
        } 
        else{
            x = x + (var_d)*((sin(phi/2)/(phi/2))*cos(phi + var_phi/2));
            y = y + (var_d)*((sin(phi/2)/(phi/2))*sin(phi + var_phi/2));
            phi = phi + var_phi;
        }
        pc.printf("x_atual = %f, y_atual = %f\n", x, y);
        
        //Funcao para obter o mapa das redondezas do robo
        get_Surroundings_Matrix(Surroundings_Matrix, x, y, Map_Matrix);
        
        //Funcao para obter a direcao que o robo deve tomar em funcao da sua posicao atual e das suas redondezas
        next_phi = get_orientation_angle(x, y, end_position_x, end_position_y, Surroundings_Matrix);
        pc.printf("nphi = %f\n", next_phi);
        
        
        pc.printf("%f\n",sqrt((double)((x-end_position_x)*(x-end_position_x) + (y-end_position_y)*(y-end_position_y))));
        
       /* 
        e = sqrt(pow(end_position_x - x, 2) + pow(end_position_y - y, 2)) - d;
        erro = erro + e;
        v = kv*e + ki*erro;
        
        pc.printf("%f\n",erro);
        pc.printf("%f\n",e);
        pc.printf("%f\n",v);
        */
        
        //Controlo proporcional da direcao
        w = k*atan2(sin(next_phi-phi),cos(next_phi-phi));

        //Enviar os comandos de velocidades para as rodas
        w_left=(v-(L/2)*w)/r;
        w_right=(v+(L/2)*w)/r;
        setSpeeds(w_left,w_right);
    }
    
        setSpeeds(0,0);
        
    return(0);
}        
        
