#include "mbed.h"
#include "Rm3100.hpp"
#include "SPI_TFT_ILI9341.h"
#include "string"
#include "Arial24x23.h"

//                  mosi, miso, sclk, cs, reset, dc
SPI_TFT_ILI9341 TFT(D8, D9, D10, D11, D12, D8);

int main(void)
{
    Serial pc(USBTX, USBRX);
    pc.baud(115200);

    printf("### RM3100 ###\r\n");
    TFT.set_font((unsigned char*) Arial24x23);  // select font 2
    TFT.locate(48,115);
    TFT.printf("Bigger Font");

    int addr = ((Rm3100::RM3100_ADDR | Rm3100::RM3100_ADDR_SSN) << 1);
    struct Rm3100::Status status = { 0 };
    struct Rm3100::Sample sample = { 0 };

    Rm3100 sensor(I2C_SDA, I2C_SCL, addr);

    sensor.Begin();
    osDelay(1);

    sensor.SetCycleCounts(200);
    osDelay(1);

    sensor.SetRate(100.0f);
    osDelay(1);

    sensor.SetContinuousMeasurementMode(true);
    osDelay(1);

    while (true) {
        sensor.GetStatus(&status);
        if (status.drdy) {
            sensor.GetSample(&sample);
            printf("x: %f, y: %f, z: %f\r\n", sample.x, sample.y, sample.z);
        }
        osDelay(10);
    }
}