#include "mbed.h"
#include "INA219.h"

Serial debug(USBTX, USBRX);
DigitalOut led(LED1);
INA219 ina219(PB_9, PB_8, 0x80, 100000);

int main()
{
    double V,C, V0, C0;
    unsigned short ctrl;

    debug.format(8);
    debug.baud(115200);
    debug.printf("INA219 - (Build:[" __DATE__ "/" __TIME__ "])\r\n\n");

    while (1)
    {
        ctrl = ina219.getRegister(0x00);
        if (ctrl != 0x399F) // Control register after power on
        {
            debug.printf("--- INA219 not found ---\r\n");
            ina219.getI2C().frequency(100000);
            led = 0;
        }
        else
        {
            V = ina219.getVoltage();            // in V
            C = ina219.getCurrent() * 1000.0;   // in mA
            if (V0 != V || C0 != C)
            {   // Voltage or Current changed
                V0 = V;
                C0 = C;
                debug.printf(" V:%2.4f V I:%4.1f mA             \r", V, C);
            }
            led = !led;
        }
        wait(0.25);
    }
}
