#include "INA219.h"

INA219::INA219(PinName sda, PinName scl, unsigned char adr, int hz) :
    _i2c(sda, scl)
{
    _i2c.frequency(hz);
    Address = adr;
}

I2C INA219::getI2C(void)
{
    return _i2c;
}

bool INA219::detect(void)
{
    _i2c.start();
    bool det = (0 == _i2c.write(Address | 1 /*write address for reading*/));
    _i2c.stop();
    return det;
}

bool INA219::getRegister(unsigned char reg, unsigned short *data)
{
    unsigned char v[2];
    v[0] = reg;
    if (0 == _i2c.write(Address, (char *)&v, 1, true))
    {
        if (0 == _i2c.read(Address, (char *)&v, 2))
        {
            *data = (v[0] << 8) | v[1];
            return true;
        }
    }
    else
    {
        _i2c.stop();
    }
    return false;
}

unsigned short INA219::getRegister(unsigned char reg)
{
    unsigned short data = 0;
    getRegister(0x00, &data);
    return data;
}

double INA219::getCurrent(void)
{
    double d = 0.0;
    unsigned short data;
    if (getRegister(0x01, &data))
    {
        d = 1e-6 * ((int)data * 100); // uV * 0.1 ohm = A
    }
    return d;
}

double INA219::getVoltage(void)
{
    double d = 0.0;
    unsigned short data;
    if (getRegister(0x02, &data))
    {
        d = 1e-3 * (int)(data >> 1); // V
    }
    return d;
}
