#ifndef MBED_BUTTON_H
#define MBED_BUTTON_H

#include "mbed.h"

#define NUMCYCLE    10
#define PRESSED     0
#define NOT_PRESSED 1

class Button
{

    public:                                                                     // public
        Button(PinName pBtn, PinMode  pBtnMode, float Time = 0);                // constructor
        void init();                                                            // initialisation
        void polling(uint8_t *iNumBtn = NULL);                                  // polls and debounce the button 
        bool isPressed();                                                       // bool value if button is pressed or not
        bool wasPressed();                                                      //
        bool isLongPress();
    
    
    private:                                                                    // private
        bool bIsPressed;                                                        // current pressing state
        bool bWasPressed;                                                       // last pressenig state
        bool bLongPress;                                                        // if current pressing state is an long press
        bool bNewState;                                                         // current state/value of button
        bool bOldState;                                                         // previous state/value of button
        bool bBtnNewAction;                                                     // flag if an action is occur
        int iNumCycle;                                                          // cycle counter
        float fTime;                                                            // if constructor creates an timer, this flag is set high
    
    
        void setLongPressFlag();
        
        DigitalIn *pin;                                                         // Input pin for Button   
        Timeout *timer;                                                         // Timer, to set a Flag for secound Mode
        
};


#endif
