#ifndef H_SC18IS602
#define H_SC18IS602

#include "mbed.h"
#include <string>

#include "PCA9555.h"

class SC18IS602
{
    public:    
        
        static const int BUFFER_SIZE        = 200;// Byte
        static const bool ACK               = true;
        static const bool NACK              = false;
        static const bool INTERRUPT         = false;
        static const bool WAIT_SEC          = 10e-6;
        
        // Register Adress
        static const int HARD_ADR           = 0x50;
        static const int USER_ADR_MASK      = 0x07;
        
        struct{
            static const uint8_t CS0            = 0x01;
            static const uint8_t CS1            = 0x02;
            static const uint8_t CS2            = 0x04;
            static const uint8_t CS3            = 0x08;
        }CMD_RW;
        
        static const int ADR_SPI_CONF       = 0xF0;
        
        struct{
            static const int WRITE          = 0xF4;
            static const int READ           = 0xF5;
            static const int EN             = 0xF6;
            static const int CONF           = 0xF7;
        }ADR_GPIO;
        
        
        //Bit position of register Configure SPI Interface
        static const int SPI_BIT_ORDER      = 5;
        static const int SPI_MODE           = 2;
        static const int SPI_CLK_RATE       = 0;
        
        // Register Value SPI bit order
        struct{
            static const int MSB            = 0;                                // MSB of the data word is transmitted first
            static const int LSB            = 1;                                // LSB of the data word is transmitted first
        }SPI_BITORDER;
        
        
        // Register Value SPI Mode (CPOL, CPHA)
        static const int SPI_MODE_00       = 0;
        static const int SPI_MODE_01       = 1;
        static const int SPI_MODE_10       = 2;
        static const int SPI_MODE_11       = 3;
        
        //Register Value - Clock Rate
        static const int SPI_RATE_58K      = 0;
        static const int SPI_RATE_115K     = 1;
        static const int SPI_RATE_461K     = 2;
        static const int SPI_RATE_1M8      = 3;
        
        
                
        // Bit position of Register GPIO Enable
        struct{
            static const int CS0          = 0;
            static const int CS1          = 1;
            static const int CS2          = 2;
            static const int CS3          = 3;
        }GPIO;
        
        
        
        // Bit position of Register GPIO config
        static const int GPIO_CONF_CS0     = 0;
        static const int GPIO_CONF_CS1     = 2;
        static const int GPIO_CONF_CS2     = 4;
        static const int GPIO_CONF_CS3     = 6;
        
        
        // Register Value of GPIO config
        static const int BIDIRECTIONAL     = 0;                                                  // quasi bidirecitonal
        static const int PUSH_PULL         = 1;                                                  //
        static const int INPUT_ONLY        = 2;                                                  // high impedance
        static const int OPEN_DRAIN        = 3;                                                  // needs an external pullup


        const int iINT;

        // public
        SC18IS602(I2C *_i2c, uint8_t uiAdr);         
        SC18IS602(I2C *_i2c, PCA9555 *_pca , uint8_t uiAdr);                    //
        SC18IS602(I2C *_i2c, DigitalIn *_IntPin, uint8_t uiAdr);                //

        
        bool configSPI(uint8_t uiConf);
        bool enableGPIO(uint8_t uiConf);
        bool configGPIO(uint8_t uiConf);

        bool gpio_pin3_on();
        bool gpio_pin3_off();
        bool gpio_toggle(uint8_t uiPort);
        
        bool sendViaSPI(uint8_t uiCS, char cAdrByte, char *cDataBytes, uint8_t uiNum);
        bool readViaSPI(uint8_t uiCS, char cAdrByte, char *cDataBytes, uint8_t uiNum);
    
    
        //void setIntFuncPtr( bool (*Int_ptr)(void));
    
    protected:                                                                    // private
        I2C *i2c;                                                               // Serial Data & Clock
        PCA9555 *pca;
        DigitalIn *IntPin;                                                      // Interrupt pin
        
        
        bool sendViaI2C(const char *cData, int iLength, string sDebug = "");
        bool readViaI2C(char *cData, int iLength, string sDebug = "");
        void waitFor(bool bInt);
        
        
        bool getInt();
        bool clearInt();
        
        //bool (*getInt_ptr)(void);
        
        
        // variable
        bool bAck;
        unsigned int uiNumByte;
        char cCmd[BUFFER_SIZE];
        
        const uint8_t SC18IS602_W;                                              // const write-address
        const uint8_t SC18IS602_R;                                              // const read-address
        
        
        char cDebug[100];
        
        int iTimeOut;
        
};


#endif
